// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Encipher/decipher support functions for Tsc.
//.............................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <richedit.h>
#include "Tscmsg.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD			dwStringSafeFlag;
extern	LARGE_INTEGER	PerformanceCounter;
extern	LPBYTE			pRandBitsBin;
extern	BOOL			bUseTimeStampCounter;
extern	DWORD			RegisteredFormats[8];
extern	HINSTANCE		hInst;
extern	LPCTSTR			lpszAppName;
extern	LPCTSTR			lpIconPointer;
extern	TCHAR			szFileToEncipher[MAX_PATH];
extern	BOOL			bSaveAsText;
extern	HWND			hMainWindow;
extern	PRINTDLG		pd;
extern	LPTBBUTTON		lpTBButtons;
extern	BUTTON_DEFS		ButtonDefs[];
extern	int				iTableDefs;
extern	HWND	        hMyToolBar;
extern	TBBUTTON		tbButtonDefs[];
extern	LPTSTR			lpszClipboard;
extern	ULONG			cAttach;
extern	lpMapiFileDesc	lpAttach;
extern	LPTSTR			lpszNA;
extern	PARAFORMAT2		pf;
extern	TCHAR			TimeSep[10];
extern	REGISTRATION	Reg;
extern	ADMIN_NAME		V1;
extern	UINT			uFindMsgString;
extern	HWND			hDlgCurrent;
extern	DWORD			dwPageCount;
extern	LPBYTE			lpOutBuffer;
extern	EDITSTREAM		eStreamRecv;
extern	HWND			hChat2;
extern	HWND			hPropertySheet;
extern	CONFIG			cfg;
extern	CHARFORMAT2		cf;
extern	BOOL			bChooseHighLightColor;

#define	RTF_MENUITEMS	28
#define DATE_ITEMS		22

BOOL			bNoCallBack;
COLORREF		crOleBkg;
BOOL			bFromChat;

// Previous directory name.
//.........................
TCHAR	szPreviousSourceDir[MAX_PATH];
TCHAR	szPreviousDestinationDir[MAX_PATH];

// Date and time formats for date and time picker.
//................................................
TCHAR	Date1[] = "MM'/'d'/'yy";
TCHAR	Date2[] = "MM'/'dd'/'yy";
TCHAR	Date3[] = "MM'/'d'/'yyyy";
TCHAR	Date4[] = "MM'/'dd'/'yyyy";
TCHAR	Date5[] = "dddd',' MMMM dd',' yyyy";
TCHAR	Date6[] = "dddd',' dd MMMM',' yyyy";
TCHAR	Date7[] = "ddd',' MMM'.' d',' yyyy";
TCHAR	Date8[] = "MMMM d',' yyyy";
TCHAR	Date9[] = "dd MMMM',' yyyy";
TCHAR	Date10[] = "yyyy'-'MM'-'dd";
TCHAR	Date11[] = "d'-'MMM'-'yy";
TCHAR	Date12[] = "d'-'MMM'-'yyyy";
TCHAR	Date13[] = "MM'.'dd'.'yy";
TCHAR	Date14[] = "MM'.'dd'.'yyyy";
TCHAR	Date15[] = "MMM'.' d',' yy";
TCHAR	Date16[] = "dd'.'MM'.'yy";
TCHAR	Date17[] = "dd'/'MM'/'yy";
TCHAR	Date18[] = "d MMMM yy";
TCHAR	Date19[] = "h':'mm tt";
TCHAR	Date20[] = "h':'mm':'ss tt";
TCHAR	Date21[] = "HH':'mm";
TCHAR	Date22[] = "HH':'mm':'ss";

LPTSTR	lpFormat[] = {(LPTSTR)&Date1,(LPTSTR)&Date2,(LPTSTR)&Date3,(LPTSTR)&Date4,
					  (LPTSTR)&Date5,(LPTSTR)&Date6,(LPTSTR)&Date7,(LPTSTR)&Date8,
					  (LPTSTR)&Date9,(LPTSTR)&Date10,(LPTSTR)&Date11,(LPTSTR)&Date12,
					  (LPTSTR)&Date13,(LPTSTR)&Date14,(LPTSTR)&Date15,(LPTSTR)&Date16,
					  (LPTSTR)&Date17,(LPTSTR)&Date18,(LPTSTR)&Date19,(LPTSTR)&Date20,
					  (LPTSTR)&Date21,(LPTSTR)&Date22};

// Date and time formats for date and time picker - GMT.
//......................................................
TCHAR	GMT1[] = "MM'/'d'/'yy 'GMT'";
TCHAR	GMT2[] = "MM'/'dd'/'yy 'GMT'";
TCHAR	GMT3[] = "MM'/'d'/'yyyy 'GMT'";
TCHAR	GMT4[] = "MM'/'dd'/'yyyy 'GMT'";
TCHAR	GMT5[] = "dddd',' MMMM dd',' yyyy 'GMT'";
TCHAR	GMT6[] = "dddd',' dd MMMM',' yyyy 'GMT'";
TCHAR	GMT7[] = "ddd',' MMM'.' d',' yyyy 'GMT'";
TCHAR	GMT8[] = "MMMM d',' yyyy 'GMT'";
TCHAR	GMT9[] = "dd MMMM',' yyyy 'GMT'";
TCHAR	GMT10[] = "yyyy'-'MM'-'dd 'GMT'";
TCHAR	GMT11[] = "d'-'MMM'-'yy 'GMT'";
TCHAR	GMT12[] = "d'-'MMM'-'yyyy 'GMT'";
TCHAR	GMT13[] = "MM'.'dd'.'yy 'GMT'";
TCHAR	GMT14[] = "MM'.'dd'.'yyyy 'GMT'";
TCHAR	GMT15[] = "MMM'.' d',' yy 'GMT'";
TCHAR	GMT16[] = "dd'.'MM'.'yy 'GMT'";
TCHAR	GMT17[] = "dd'/'MM'/'yy 'GMT'";
TCHAR	GMT18[] = "d MMMM yy 'GMT'";
TCHAR	GMT19[] = "h':'mm tt 'GMT'";
TCHAR	GMT20[] = "h':'mm':'ss tt 'GMT'";
TCHAR	GMT21[] = "HH':'mm 'GMT'";
TCHAR	GMT22[] = "HH':'mm':'ss 'GMT'";

LPTSTR	lpGMTFormat[] = {(LPTSTR)&GMT1,(LPTSTR)&GMT2,(LPTSTR)&GMT3,(LPTSTR)&GMT4,
					     (LPTSTR)&GMT5,(LPTSTR)&GMT6,(LPTSTR)&GMT7,(LPTSTR)&GMT8,
					     (LPTSTR)&GMT9,(LPTSTR)&GMT10,(LPTSTR)&GMT11,(LPTSTR)&GMT12,
					     (LPTSTR)&GMT13,(LPTSTR)&GMT14,(LPTSTR)&GMT15,(LPTSTR)&GMT16,
					     (LPTSTR)&GMT17,(LPTSTR)&GMT18,(LPTSTR)&GMT19,(LPTSTR)&GMT20,
					     (LPTSTR)&GMT21,(LPTSTR)&GMT22};

BOOL		bUseGmt;

TCHAR			szInsertBuffer[256];
FINDREPLACE		FindReplace;
HWND			hCurrentRtfWnd;
LPBYTE			lpFind;
LPBYTE			lpReplaceWith;
HWND			hFindReplace;
LPFINDREPLACE	lpFr;
FINDTEXTEX		ft;
CHOOSECOLOR		crHL;
COLORREF		crHLCurrent = 0xffffff;
COLORREF		crHLCustom[17];

// Menu items, etc., used by our rich edit text control.
//......................................................
MENUITEMINFO	miiUndo;
MENUITEMINFO	miiRedo;
MENUITEMINFO	miiSeparator1;
MENUITEMINFO	miiCut;
MENUITEMINFO	miiCopy;
MENUITEMINFO	miiPaste;
MENUITEMINFO	miiDelete;
MENUITEMINFO	miiSeparator2;
MENUITEMINFO	miiSelectAll;
MENUITEMINFO	miiSeparator3;
MENUITEMINFO	miiFind;
MENUITEMINFO	miiReplace;
MENUITEMINFO	miiSeparator4;
MENUITEMINFO	miiImportAFile;
MENUITEMINFO	miiSaveAs;
MENUITEMINFO	miiSeparator5;
MENUITEMINFO	miiPrint;
MENUITEMINFO	miiSeparator6;
MENUITEMINFO	miiParaFmt;
MENUITEMINFO	miiDateTime;
MENUITEMINFO	miiSeparator7;
MENUITEMINFO	miiSmileys;
MENUITEMINFO	miiInsertPic;
MENUITEMINFO	miiSeparator8;
MENUITEMINFO	miiHighLightOn;
MENUITEMINFO	miiHighLightOff;
MENUITEMINFO	miiDelete1;
MENUITEMINFO	miiSelectAll1;

LPMENUITEMINFO	lpmii[] = {&miiUndo,&miiRedo,&miiSeparator1,&miiCut,\
						   &miiCopy,&miiPaste,&miiDelete,&miiSeparator2,&miiSelectAll,\
						   &miiSeparator3,&miiFind,&miiReplace,&miiSeparator4,
						   &miiImportAFile,&miiSaveAs,&miiSeparator5,&miiPrint,
						   &miiSeparator6,&miiParaFmt,&miiDateTime,&miiSeparator7,&miiSmileys,
						   &miiInsertPic,&miiSeparator8,&miiHighLightOn,&miiHighLightOff,
						   &miiDelete1,&miiSelectAll1};

TCHAR			szUndo[]		= "&Undo\tCtrl+Z";
TCHAR			szRedo[]		= "&Redo";
TCHAR			szNull1[]		= "";
TCHAR			szCut[]			= "Cu&t\tCtrl+X";
TCHAR			szCopy[]		= "&Copy\tCtrl+C";
TCHAR			szPaste[]		= "&Paste\tCtrl+V";
TCHAR			szDelete1[]		= "&Delete\tShift+Del";
TCHAR			szNull2[]		= "";
TCHAR			szSelectAll[]	= "Select &All\tCtrl+A";
TCHAR			szNull3[]		= "";
TCHAR			szFind[]		= "F&ind...";
TCHAR			szReplace[]		= "Replac&e...";
TCHAR			szNull4[]		= "";
TCHAR			szImport[]		= "Imp&ort A File...";
TCHAR			szSaveAs[]		= "Sa&ve As...";
TCHAR			szNull5[]		= "";
TCHAR			szPrint[]		= "Pri&nt...";
TCHAR			szNull6[]		= "";
TCHAR			szParaFmt[]		= "&Format Paragraph...";
TCHAR			szTimeDate[]	= "Insert Date/Ti&me...";
TCHAR			szNull7[]		= "";
TCHAR			szSmileys[]		= "Smile&ys...";
TCHAR			szInsertPic[]	= "In&sert Picture...";
TCHAR			szNull8[]		= "";
TCHAR			szHighOn[]		= "Select &Highlight Color...";
TCHAR			szHighOff[]		= "Turn Highli&ghting Off";
TCHAR			szDelete3[]		= "&Delete";
TCHAR			szSelectA1[]	= "Select &All";

LPTSTR			lpNames[] = {(LPTSTR)&szUndo,(LPTSTR)&szRedo,(LPTSTR)&szNull1,
							 (LPTSTR)&szCut,(LPTSTR)&szCopy,(LPTSTR)&szPaste,
							 (LPTSTR)&szDelete1,(LPTSTR)&szNull2,(LPTSTR)&szSelectAll,
							 (LPTSTR)&szNull3,(LPTSTR)&szFind,(LPTSTR)&szReplace,
							 (LPTSTR)&szNull4,(LPTSTR)&szImport,(LPTSTR)&szSaveAs,
							 (LPTSTR)&szNull5,(LPTSTR)&szPrint,(LPTSTR)&szNull6,
							 (LPTSTR)&szParaFmt,(LPTSTR)&szTimeDate,(LPTSTR)&szNull7,
							 (LPTSTR)&szSmileys,(LPTSTR)&szInsertPic,(LPTSTR)&szNull8,
							 (LPTSTR)&szHighOn,(LPTSTR)&szHighOff,(LPTSTR)&szDelete3,
							 (LPTSTR)&szSelectA1};

TCHAR			szMsgSaveAs[] = "File Name: %s\n\nYour File was successfully saved to disk.";

LPCTSTR		lpSetOne = "SMILEYS1";
LPCTSTR		lpSetTwo = "SMILEYS2";
LPCTSTR		lpSetThree = "SMILEYS3";

// Variables used by the encryption routines.
//...........................................
DWORD	Dividend1;
DWORD	Divisor1;
DWORD	Seed;
DWORD	RdmFactor;
DWORD	DbleNumber;
DWORD	LimitNumber;

DWORD	TopsArray[256];
DWORD	FactorArray[256];
DWORD	SeedsArray[256];

// Random factor array shift value of 17 to 24.
//.............................................
DWORD	RandomFactorShift;

BYTE	LastSeed;
BYTE	RingMask;

int		iSpacing = IDC_SPACE1;

// Bit position in random number file of RandomFactorShift.
//.........................................................
DWORD	RFSBitPosition = 16387;

// Virtual keyboard variables.
//............................
HWND			hEditCtrl;
TCHAR			szDupEditCtrl[MAX_PATH];
LPBYTE			lpInsertPoint;
LPBYTE			lpInsertPoint1;
DWORD			dwPassWordLength;
LPBYTE			lpVPassWord;
DWORD			dwSetInUse;
BYTE			StaticSet[6][27] = { 32, 65, 66, 67, 68, 69, 70, 71, 72,	// caps
									 73, 74, 75, 76, 77, 78, 79, 80, 81,
									 82, 83, 84, 85, 86, 87, 88, 89, 90,
									 32, 97, 98, 99,100,101,102,103,104,	// small
									105,106,107,108,109,110,111,112,113,
									114,115,116,117,118,119,120,121,122,

									 37, 39, 40, 41, 42, 43, 44, 45, 46,	// Math
									 47, 48, 49, 50, 51, 52, 53, 54, 55, 
									 56, 57, 35, 61, 91, 92, 93, 94, 95,

									 33, 34, 60, 36,219, 38,220,221,222,	// Symbols
									223, 58, 59,224,225, 62, 63, 64,226,
									227,228,163,177, 96,123,124,125,126,

									192,193,194,195,196,197,198,199,200,	// International
									201,202,203,204,205,206,207,208,209,
									210,211,212,213,214,215,216,217,218,

									231,232,233,234,235,236,237,238,239,	// International
									240,241,242,243,244,245,246,247,248,
									249,250,251,252,253,254,255,230,229};

BYTE			ScratchSet[6][27];

BYTE			DynamicSet[6][27];

LPCTSTR			lpVirtual640 = "VIRTUALKEYS640";
LPCTSTR			lpVirtual800 = "VIRTUALKEYS800";
LPCTSTR			lpVirtual1024 = "VIRTUALKEYS1024";

// RTF header strings.
//....................
TCHAR			szRTFHeader[] = "{\\rtf\\ansi\\ansicpg1252\\deff0\\deflang1033{\\fonttbl{\\f0\\%s\\fcharset0 %s;}}{\\pict\\wmetafile8\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0\\picw%lu\\pich%lu\\picwgoal%lu\\pichgoal%lu ";
TCHAR			szRTFImagePost[] = "}}";

// Font families.
//...............
TCHAR			szUnknown[] = "\\fnil";
TCHAR			szRoman[]	= "\\froman";
TCHAR			szSwiss[]	= "\\fswiss";
TCHAR			szModern[]	= "\\fmodern";
TCHAR			szScript[]	= "\\fscript";
TCHAR			szDecor[]	= "\\fdecor";
TCHAR			szTech[]	= "\\ftech";
TCHAR			szBidi[]	= "\\fbidi";

LPTSTR			lpFontFamily[] = {(LPTSTR)&szUnknown,(LPTSTR)&szRoman,(LPTSTR)&szSwiss,
								  (LPTSTR)&szModern,(LPTSTR)&szScript,(LPTSTR)&szDecor,
								  (LPTSTR)&szTech,(LPTSTR)&szBidi};

TCHAR			szInsertSmiley[] = "::)  ";

// Popup the virtual keyboard.
//............................
VOID VirtualKeyboard(HWND hDlg, int iEditBox, LPBYTE lppw, DWORD dwPwLength)
{
	int				iDlgResult;
	DWORD			i, j, b;
	DWORD			dwOldHelpTopic;
	LPCTSTR			lpDialogBox;
	DWORD			dwStringLength;
	BYTE			AllEqual;

	CopyMemory(&ScratchSet,&StaticSet,sizeof(StaticSet));
	dwSetInUse = 0;
	dwPassWordLength = dwPwLength;
	lpVPassWord = lppw;

	// Lets randomize the dynamic set from the static set.
	//....................................................
	for (i = 0; i < 6; i++)
	{
		for (j = 0; j < 27; j++)
		{
			while(TRUE)
			{
				GetRandomBits(5,&b);
				if (b > 26)
				{
					continue;
				}
				if (ScratchSet[i][b])
				{
					DynamicSet[i][j] = ScratchSet[i][b];
					ScratchSet[i][b] = 0;
					break;
				}
				else
				{
					continue;
				}
			}
		}
	}
	// Get any portion of the password that has already been entered.
	//...............................................................
	hEditCtrl = GetDlgItem(hDlg,iEditBox);
	ZeroMemory(&szDupEditCtrl,sizeof(szDupEditCtrl));
	GetDlgItemText(hDlg,iEditBox,(LPTSTR)&szDupEditCtrl,sizeof(szDupEditCtrl));

	// If the previous data was entered via the virtual keyboard all the characters
	// will be 0x191 under the edit box.
	//.............................................................................
	dwStringLength = lstrlen((LPCTSTR)&szDupEditCtrl);

	if (dwStringLength)
	{
		__asm
		{
			mov		ecx,dwStringLength
			mov		al,DEFAULT_CHAR
			mov		edi,offset szDupEditCtrl
			repe	scasb
			sete	AllEqual
		}
		// If they are all equal, set the insertionpoints for the variables.
		//..................................................................
		if (AllEqual)
		{
			lpInsertPoint = szDupEditCtrl;
			lpInsertPoint += lstrlen((LPCTSTR)&szDupEditCtrl);
			lpInsertPoint1 = lppw;
			lpInsertPoint1 += lstrlen((LPCTSTR)lppw);
		}
		else
		{
			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_VIRTUAL_WARNING,
						   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
			ZeroMemory(lppw,dwPwLength);
			lpInsertPoint1 = lppw;
			ZeroMemory(&szDupEditCtrl,sizeof(szDupEditCtrl));
			lpInsertPoint = szDupEditCtrl;
			SetWindowText(hEditCtrl,(LPCTSTR)&szDupEditCtrl);
		}
	}
	else
	{
		lpInsertPoint = szDupEditCtrl;
		lpInsertPoint1 = lppw;
	}
	dwOldHelpTopic = ChangeHelpTopic(IDH_VIRTUAL_KEYBOARD);

	// Determine the current display resolution.
	//..........................................
	i = GetSystemMetrics(SM_CXFULLSCREEN);

	// Display the dialog box to read a message with depending
	// on the current screen resolution.
	//...............................................
	if (i >= 950)
	{
		lpDialogBox = lpVirtual1024;
	}
	else if (i >= 750)
	{
		lpDialogBox = lpVirtual800;
	}
	else
	{
		lpDialogBox = lpVirtual640;
	}
	// Display the dialog box.
	//........................
	iDlgResult = DialogBox(hInst,lpDialogBox,hDlg,(DLGPROC)VirtualKeysProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
	}
	ZeroMemory(&szDupEditCtrl,sizeof(szDupEditCtrl));
	EmptyTheMessageQue();
	ChangeHelpTopic(dwOldHelpTopic);
}

// CALLBACK procedure for the virtual keyboard dialog box.
//........................................................
LRESULT CALLBACK VirtualKeysProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD		i, j;
	TCHAR		szButton[5];
	int			iButtonId;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			RECT		rc;

			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			ZeroMemory(&szButton,sizeof(szButton));

			GetWindowRect(hDlg,&rc);
			if (rc.top > 130)
			{
				rc.top -= 130;
				SetWindowPos(hDlg,HWND_TOP,rc.left,rc.top,0,0,SWP_NOSIZE);
			}
			// Populate the keyboard buttons.
			//...............................
			i = dwSetInUse;
			iButtonId = IDC_VK11;

			for (j = 0; j < 27; j++)
			{
				ZeroMemory(&szButton,sizeof(szButton));

				if (DynamicSet[i][j] == 0x20)
				{
					CopyMemory(&szButton,TEXT("SPC"),3);
					SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
				}
				else
				{
					szButton[0] = DynamicSet[i][j];
					SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
				}
				iButtonId++;
			}
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_VK11:
				case IDC_VK12:
				case IDC_VK13:
				case IDC_VK14:
				case IDC_VK15:
				case IDC_VK16:
				case IDC_VK17:
				case IDC_VK18:
				case IDC_VK19:
				case IDC_VK21:
				case IDC_VK22:
				case IDC_VK23:
				case IDC_VK24:
				case IDC_VK25:
				case IDC_VK26:
				case IDC_VK27:
				case IDC_VK28:
				case IDC_VK29:
				case IDC_VK31:
				case IDC_VK32:
				case IDC_VK33:
				case IDC_VK34:
				case IDC_VK35:
				case IDC_VK36:
				case IDC_VK37:
				case IDC_VK38:
				case IDC_VK39:
				{
					j = LOWORD(wParam);
					j -= IDC_VK11;
					i = dwSetInUse;

					// Set the char to send to the edit control to 191.
					//.................................................
					*lpInsertPoint = DEFAULT_CHAR;
					*lpInsertPoint1 = DynamicSet[i][j];
					SetWindowText(hEditCtrl,(LPCTSTR)&szDupEditCtrl);
					lpInsertPoint++;
					lpInsertPoint1++;
				}
				break;

				case IDC_ABCCAP:
				{
					// Switch to the all caps buttons.
					//................................
					if (dwSetInUse != 0)
					{
						dwSetInUse = 0;
						i = dwSetInUse;
						iButtonId = IDC_VK11;

						for (j = 0; j < 27; j++)
						{
							ZeroMemory(&szButton,sizeof(szButton));

							if (DynamicSet[i][j] == 0x20)
							{
								CopyMemory(&szButton,TEXT("SPC"),3);
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							else
							{
								szButton[0] = DynamicSet[i][j];
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							iButtonId++;
						}
					}
				}
				break;

				case IDC_ABCSMALL:
				{
					// Switch to the all small letter buttons.
					//........................................
					if (dwSetInUse != 1)
					{
						dwSetInUse = 1;
						i = dwSetInUse;
						iButtonId = IDC_VK11;

						for (j = 0; j < 27; j++)
						{
							ZeroMemory(&szButton,sizeof(szButton));

							if (DynamicSet[i][j] == 0x20)
							{
								CopyMemory(&szButton[0],TEXT("SPC"),3);
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							else
							{
								szButton[0] = DynamicSet[i][j];
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							iButtonId++;
						}
					}
				}
				break;

				case IDC_MATH:
				{
					// Switch to the math and symbols buttons.
					//........................................
					if (dwSetInUse != 2)
					{
						dwSetInUse = 2;
						i = dwSetInUse;
						iButtonId = IDC_VK11;

						ZeroMemory(&szButton,sizeof(szButton));

						for (j = 0; j < 27; j++)
						{
							szButton[0] = DynamicSet[i][j];
							SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							iButtonId++;
						}
					}
				}
				break;

				case IDC_SYMBOLS:
				{
					// Switch to the symbols buttons.
					//...............................
					if (dwSetInUse != 3)
					{
						dwSetInUse = 3;
						i = dwSetInUse;
						iButtonId = IDC_VK11;

						for (j = 0; j < 27; j++)
						{
							ZeroMemory(&szButton,sizeof(szButton));

							if (DynamicSet[i][j] == 0x26)
							{
								CopyMemory(&szButton,TEXT("&&"),2);
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							else
							{
								szButton[0] = DynamicSet[i][j];
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							iButtonId++;
						}
					}
				}
				break;

				case IDC_INTERNATIONAL:
				{
					// Switch to the international buttons.
					//...............................
					if (dwSetInUse != 4)
					{
						dwSetInUse = 4;
						i = dwSetInUse;
						iButtonId = IDC_VK11;

						for (j = 0; j < 27; j++)
						{
							ZeroMemory(&szButton,sizeof(szButton));

							if (DynamicSet[i][j] == 0x26)
							{
								CopyMemory(&szButton,TEXT("&&"),2);
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							else
							{
								szButton[0] = DynamicSet[i][j];
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							iButtonId++;
						}
					}
				}
				break;

				case IDC_INTERNATIONAL1:
				{
					// Switch to the international buttons.
					//...............................
					if (dwSetInUse != 5)
					{
						dwSetInUse = 5;
						i = dwSetInUse;
						iButtonId = IDC_VK11;

						for (j = 0; j < 27; j++)
						{
							ZeroMemory(&szButton,sizeof(szButton));

							if (DynamicSet[i][j] == 0x26)
							{
								CopyMemory(&szButton,TEXT("&&"),2);
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							else
							{
								szButton[0] = DynamicSet[i][j];
								SetDlgItemText(hDlg,iButtonId,(LPCTSTR)&szButton);
							}
							iButtonId++;
						}
					}
				}
				break;

				case IDC_BACKSPACE:
				{
					// Backspace one character.
					//.........................
					if (lpInsertPoint > szDupEditCtrl)
					{
						lpInsertPoint--;
						*lpInsertPoint = 0;
						SetWindowText(hEditCtrl,(LPCTSTR)&szDupEditCtrl);

						lpInsertPoint1--;
						*lpInsertPoint1 = 0;
					}
				}
				break;

				case IDC_CLEAR:
				{
					// Clear what we have so far.
					//...........................
					lpInsertPoint = szDupEditCtrl;
					ZeroMemory(&szDupEditCtrl,sizeof(szDupEditCtrl));
					SetWindowText(hEditCtrl,(LPCTSTR)&szDupEditCtrl);

					lpInsertPoint1 = lpVPassWord;
					ZeroMemory(lpVPassWord,dwPassWordLength);
				}
				break;

				case IDOK:
				{
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Clear all the math variables.
//..............................
VOID ClearMathVariables()
{
	Dividend1 = 0;
	Divisor1 = 0;
	Seed = 0;
	RdmFactor = 0;
	DbleNumber = 0;
	LimitNumber = 0;
	ZeroMemory(&TopsArray,sizeof(TopsArray));
	ZeroMemory(&FactorArray,sizeof(FactorArray));
	ZeroMemory(&SeedsArray,sizeof(SeedsArray));
	RandomFactorShift = 0;
	LastSeed = 0;
}

// Get the number of requested random bits from the random bits bin
// and place them in the destination address.
//.................................................................
VOID GetRandomBits(DWORD BitsRequested, LPVOID Destination)
{
	DWORD	Mask32;
	LPVOID	BitsDestination;

	BitsDestination = Destination;

	while (BitsRequested != 0)
	{
		if (BitsRequested >= 32)
		{
			BitsRequested -= 32;
			Mask32 = -1;
		}
		else
		{
			__asm
			{
				mov		Mask32,0
				mov		eax,-1
				mov		cl,byte ptr BitsRequested
				shld	Mask32,eax,cl
				mov		BitsRequested,0
			}
		}
		// Read the high performance counter or the time stamp counter.
		//.............................................................
		if (bUseTimeStampCounter)
		{
			__asm
			{
				rdtsc
				mov		PerformanceCounter.LowPart,eax
			}
		}
		else
		{
			QueryPerformanceCounter(&PerformanceCounter);
		}
		// Get up to 32 random bits and place them in the destination.
		//............................................................
		__asm
		{
			mov		esi,pRandBitsBin
			mov		edi,BitsDestination
			mov		ebx,PerformanceCounter.LowPart
			and		ebx,0ffffh
			mov		ecx,ebx
			shr		ebx,5
			shl		ebx,2
			and		cl,1fh
			mov		eax,dword ptr [esi][ebx]
			cmp		ebx,8188
			jne		L1
			mov		edx,dword ptr [esi]
			jmp		L2
		L1:	mov		edx,dword ptr [esi][ebx+4]
		L2: shrd	eax,edx,cl
			and		eax,Mask32
			stosd
			mov		BitsDestination,edi
		}
		// We only stir the bits if we are using the High Performance counter.
		//....................................................................
		if (!bUseTimeStampCounter)
		{
			StirTheBits();
		}
	}
}

// Get a pseudo random number.
//............................
DWORD GetRandomNumber()
{
	// Get the first byte of the previous LastSeed to be used as the
	// pseudo random number to index into one of the 256 pseudo
	// random number generators.
	//..............................................................
	__asm
	{
		movzx	esi,LastSeed
		mov		eax,SeedsArray[esi*4]	// Get seed from seeds array
		xor		edx,edx
		mov		ebx,Divisor1
		push	eax						// Save the seed
		div		ebx
		mov		ecx,eax					// Quotient to ecx
		pop		eax
		push	edx						// Save remainder on stack
		mov		edx,DbleNumber
		add		eax,ecx					// Add quotient to seed
		jnc		L1
		sub		eax,ecx					// Make it the same
		jmp		L3
	
		// If the new seed is greater than DbleNumber just
	    // go and subtract the TopsArray value from it.
		//................................................
	L1:	cmp		eax,edx
		jae		L3
		mov		ecx,FactorArray[esi*4]	// Add random factor to seed
		add		eax,ecx
		jnc		L2
		sub		eax,ecx					// Make it the same
		jmp		L3
	
		//If the new seed is greater than DbleNumber.
		//...........................................
	L2: cmp		eax,edx
		jb		L4
	L3:	mov		ecx,TopsArray[esi*4]
		sub		eax,ecx
	
		// Put the NEW seed into the table and the low byte into
		// the LastSeed variable.
		//......................................................
	L4:	mov		SeedsArray[esi*4],eax
	
		// Mask off the number of rings in use. Can be 
		// 4, 8, 16, 32, 64, or 256.
		//............................................
		and		al,RingMask
		mov		LastSeed,al
		pop		eax
	}
}

// Get pseudo random number. Only used to setup our
// 3 arrays of 256 random numbers each.
//.................................................
DWORD GetRandNum()
{
	__asm
	{
		mov		eax,Seed
		xor		edx,edx
		mov		ebx,Divisor1
		div		ebx
		
		// Save remainder on the stack.
		//.............................
		push	edx
		mov		ebx,eax				// Quotient to ebx
		mov		eax,Seed			// Seed to eax again
		mov		ecx,RdmFactor
		mov		edx,DbleNumber
		add		eax,ebx				// Add quotient to seed
		jnc		L1
		sub		eax,ebx				// Make the same as before
		jmp		L3
	L1:	cmp		eax,edx
		jae		L3
		add		eax,ecx				// Add random factor
		jnc		L2
		sub		eax,ecx				// Make the same as before
		jmp		L3
	L2:	cmp		eax,edx
		jb		L4
	L3:	mov		ebx,LimitNumber
		sub		eax,ebx
	L4:	mov		Seed,eax			// NEW seed
		mov		LastSeed,al
		pop		eax
	}
}

// Set the random factor array shift value.
// It must be between 17 and 24.
//.........................................
VOID SetRFShiftValue(LPVOID lpBuffer)
{
	__asm
	{
		mov		edi,lpBuffer
		mov		ebx,RFSBitPosition
		mov		ecx,ebx
		shr		ebx,3
		and		ecx,7h
		mov		eax,dword ptr [edi][ebx]
		shr		eax,cl
		and		eax,1fh
		jmp		L2
	L1:	add		eax,8
	L2:	cmp		eax,17
		jb		L1
		jmp		L4
	L3:	sub		eax,8
	L4:	cmp		eax,24
		ja		L3
		mov		RandomFactorShift,eax
	}
}

// Setup the arrays for the pseudo random number generators.
//..........................................................
VOID SetupArrays(LPVOID lpBuffer)
{
	// First set the random factor array shift value.
	//...............................................
	SetRFShiftValue(lpBuffer);

	__asm
	{
		// Get the last random number in the file and double it.
		//......................................................
		mov		edi,lpBuffer
		mov		eax,dword ptr [edi][(Goal-1)*4]
		clc
		rcl		eax,1
		jnc		L1
		mov		eax,-1
	L1:	mov		DbleNumber,eax
		
		// Get the first number in the file and make it the
		// limit number.
		//..................................................
		mov		eax,dword ptr [edi]
		mov		LimitNumber,eax

		// Setup the random factor value.
		//...............................
		mov		ecx,RandomFactorShift
		xor		ebx,ebx
		shrd	eax,ebx,cl
		mov		RdmFactor,eax

		// Select 768 numbers randomly from the buffer.
		//.............................................
		mov		Divisor1,Goal
	}
	// Fill the 3 arrays.
	//...................
	FillOneArray(lpBuffer,(LPVOID)&TopsArray);
	FillOneArray(lpBuffer,(LPVOID)&FactorArray);
	FillOneArray(lpBuffer, (LPVOID)&SeedsArray);

	__asm
	{
		// Shift the numbers in the FactorArray.
		//......................................
		xor		ebx,ebx
		xor		edi,edi
		mov		ecx,NumbersWanted/3
	L2:	push	ecx
		mov		ecx,RandomFactorShift
		mov		eax,FactorArray[edi*4]
		shrd	eax,ebx,cl
		mov		FactorArray[edi*4],eax
		inc		edi
		pop		ecx
		loop	L2
	}
}

// Fill one array with randomly selected numbers.
//...............................................
VOID FillOneArray(LPVOID lpBuffer, LPVOID lpArray)
{
	__asm
	{
		xor		esi,esi
		mov		ecx,NumbersWanted/3

		// Get the randomly selected numbers.
		//...................................
	L1:	push	ecx
		push	esi
	L2:	call	GetRandNum
		mov		ebx,eax
		mov		edi,lpBuffer

		// Do not use a number twice.
		//...........................
		cmp		dword ptr [edi][ebx*4],0
		je		L2
		mov		eax,dword ptr [edi][ebx*4]
		mov		dword ptr [edi][ebx*4],0
		pop		esi
		mov		edi,lpArray
		mov		dword ptr [edi][esi*4],eax
		inc		esi
		pop		ecx
		loop	L1
	}
}

// Setup the rtf context menu.
//............................
VOID SetupRtfContextMenu()
{
	int			i;

	// Go into a loop and setup the menu items.
	//.........................................
	for (i = 0; i < RTF_MENUITEMS; i++)
	{
		lpmii[i]->cbSize = sizeof(MENUITEMINFO);

		// If we have the separators do things a little differently.
		//..........................................................
		if (i == 2 || i == 7 || i == 9 || i == 12 || i == 15 || i == 17 || i == 20 || i == 23)
		{
			lpmii[i]->fMask = MIIM_TYPE;
			lpmii[i]->fType = MFT_SEPARATOR;
		}
		else
		{
			lpmii[i]->fMask = MIIM_ID | MIIM_TYPE | MIIM_STATE;
			lpmii[i]->fType = MFT_STRING;

			if (i == 13 || i == 18 || i == 19 || i == 22 || i == 24 || i == 25)
			{
				lpmii[i]->fState = MFS_ENABLED;
			}
			else if ( i == 21)
			{
				if (bNoCallBack)
				{
					lpmii[i]->fState = MFS_GRAYED;
				}
				else
				{
					lpmii[i]->fState = MFS_ENABLED;
				}
			}
			else
			{
				lpmii[i]->fState = MFS_GRAYED;
			}
			lpmii[i]->wID = (IDM_RTF_BASE + i);
			lpmii[i]->dwTypeData = (LPVOID)lpNames[i];
			lpmii[i]->cch = sizeof(lpNames[i]);
		}
	}
}

// Popup menu for the read message rtf control.
//.............................................
VOID ReadContextMenu(HWND hDlg,HWND hControl, LPARAM lParam)
{
	HMENU			hMenu = 0;
	BOOL			bResult;
	int				x, y;
	RECT			rc;
	CHARRANGE		crange;
	DWORD			dwTotalChar1;
	DWORD			dwTotalChar2;

	SetupRtfContextMenu();

	hMenu = CreatePopupMenu();
	if (!hMenu)
	{
		goto ReadEnd;
	}
	SendMessage(hControl,EM_EXGETSEL,0,(LPARAM)&crange);

	// Get the total number of characters in the rtf control.
	//.......................................................
	dwTotalChar1 = GetTheTotalCharacters(hControl);

	dwTotalChar2 = crange.cpMax - crange.cpMin;

	if (crange.cpMax != crange.cpMin)
	{
		miiCopy.fState = MFS_ENABLED;
	}
	if (dwTotalChar2 >= dwTotalChar1)
	{
		miiSelectAll.fState = MFS_GRAYED;
	}
	else
	{
		miiSelectAll.fState = MFS_ENABLED;
	}
	// Set the save as if we have anything in the message.
	//....................................................
	if (dwTotalChar1 > 0)
	{
		miiSaveAs.fState = MFS_ENABLED;
		miiPrint.fState = MFS_ENABLED;
	}
	// Insert the menu items.
	//.......................
	bResult = InsertMenuItem(hMenu,0,TRUE,lpmii[4]);
	if (!bResult)
	{
		goto ReadEnd;
	}
	bResult = InsertMenuItem(hMenu,1,TRUE,lpmii[8]);
	if (!bResult)
	{
		goto ReadEnd;
	}
	bResult = InsertMenuItem(hMenu,2,TRUE,lpmii[9]);
	if (!bResult)
	{
		goto ReadEnd;
	}
	bResult = InsertMenuItem(hMenu,3,TRUE,lpmii[14]);
	if (!bResult)
	{
		goto ReadEnd;
	}
	bResult = InsertMenuItem(hMenu,4,TRUE,lpmii[15]);
	if (!bResult)
	{
		goto ReadEnd;
	}
	bResult = InsertMenuItem(hMenu,5,TRUE,lpmii[16]);
	if (!bResult)
	{
		goto ReadEnd;
	}
	x = LOWORD(lParam);
	y = HIWORD(lParam);

	if (x == 0xffff)
	{
		GetWindowRect(hControl,&rc);
		x = rc.left + ((rc.right - rc.left) / 2);
		y = rc.top + 25;
	}
	// Display the read message context menu.
	//.......................................
	bResult = TrackPopupMenuEx(hMenu,TPM_LEFTALIGN | TPM_TOPALIGN | 
							   TPM_NONOTIFY | TPM_RIGHTBUTTON |
							   TPM_RETURNCMD,x,y,hDlg,NULL);
	if (bResult)
	{
		// Process the returned commands.
		//...............................
		if (bResult == IDM_RTF_COPY)
		{
			SendMessage(hControl,WM_COPY,0,0);
		}
		else if (bResult == IDM_RTF_SELECTALL)
		{
			crange.cpMin = 0;
			crange.cpMax = -1;
			SendMessage(hControl,EM_EXSETSEL,0,(LPARAM)&crange);
		}
		else if (bResult == IDM_RTF_SAVEAS)
		{
			SaveMsgAs(hDlg,IDC_RNOTE);
		}
		else if (bResult == IDM_RTF_PRINT)
		{
			PrintRTF(hDlg,hControl,IDC_RNOTE,IDC_RSUBJECT);
		}
	}

	ReadEnd:

	// Close the menu.
	//................
	if (hMenu)
	{
		DestroyMenu(hMenu);
	}
}

// Context menu for file attachments.
//...................................
VOID AttachContextMenu(HWND hDlg, HWND hControl, LPARAM lParam)
{
	HMENU			hMenu = 0;
	DWORD			dwTotalFiles;
	DWORD			dwFilesSelected;
	DWORD			dwNewTotal;
	BOOL			bResult;
	int				x, y;
	RECT			rc;
	lpMapiFileDesc	lpAttach1 = 0;
	lpMapiFileDesc	lpAttachT;
	LPINT			lpInt = 0;
	ULONG			idx;
	ULONG			idx1;
	ULONG			idx2;
	ULONG			ulResult = MAPI_USER_ABORT;
	BOOL			bErr;

	SetupRtfContextMenu();

	hMenu = CreatePopupMenu();
	if (!hMenu)
	{
		goto AttachEnd;
	}
	// Determine the number of files selected and total number of files.
	//..................................................................
	dwTotalFiles = SendMessage(hControl,LB_GETCOUNT,0,0);
	dwFilesSelected = SendMessage(hControl,LB_GETSELCOUNT,0,0);
	dwNewTotal = (dwTotalFiles - dwFilesSelected);

	// If no files selected, gray delete menu item.
	//.............................................
	if (dwFilesSelected > 0)
	{
		miiDelete1.fState = MFS_ENABLED;
	}
	// If the number of files selected = the total number of files,
	// set select all to grayed.
	//.............................................................
	if (dwTotalFiles != dwFilesSelected)
	{
		miiSelectAll1.fState = MFS_ENABLED;
	}
	// Insert the 3 menu items.
	//.........................
	bResult = InsertMenuItem(hMenu,0,TRUE,&miiDelete1);
	if (!bResult)
	{
		goto AttachEnd;
	}
	bResult = InsertMenuItem(hMenu,1,TRUE,&miiSeparator1);
	if (!bResult)
	{
		goto AttachEnd;
	}
	bResult = InsertMenuItem(hMenu,2,TRUE,&miiSelectAll1);
	if (!bResult)
	{
		goto AttachEnd;
	}
	x = LOWORD(lParam);
	y = HIWORD(lParam);

	if (x == 0xffff)
	{
		GetWindowRect(hControl,&rc);
		x = rc.left + ((rc.right - rc.left) / 2);
		y = rc.top + 10;
	}
	// Display the rtf context menu.
	//..............................
	bResult = TrackPopupMenuEx(hMenu,TPM_LEFTALIGN | TPM_TOPALIGN | 
							   TPM_NONOTIFY | TPM_RIGHTBUTTON |
							   TPM_RETURNCMD,x,y,hDlg,NULL);
	if (bResult)
	{
		if (bResult == IDM_RTF_DELETE1)
		{
			// If we have selected all of the items to delete it is easy.
			//...........................................................
			if (dwFilesSelected == dwTotalFiles)
			{
				PvFree((LPBYTE)lpAttach);
				lpAttach = NULL;
				cAttach = 0;
				SendMessage(hControl,LB_RESETCONTENT,0,0);
			}
			else
			{
				// Allocate memory for the list of identifier integers.
				//.....................................................
				lpInt = AllocateMemory(dwFilesSelected * sizeof(int));
				if (!lpInt)
				{
					goto AttachEnd;
				}
				SendMessage(hControl,LB_GETSELITEMS,dwFilesSelected,(LPARAM)lpInt);

				// Setup a new memory structure to hold the new smaller list of files.
				//....................................................................
				lpAttach1 = (lpMapiFileDesc)PvAlloc(dwNewTotal * sizeof(MapiFileDesc));
				if (!lpAttach1)
				{
					goto AttachEnd;
				}
				ZeroMemory(lpAttach1,(dwNewTotal * sizeof(MapiFileDesc)));

				// Save the old list of files. Delete if we have a good new list.
				//...............................................................
				lpAttachT = lpAttach;
				idx1 = 0;
				idx2 = 0;

				// Copy the selections we did not delete to the new structure.
				//............................................................
				for (idx = 0; idx < cAttach; idx++)
				{
					if (idx == (ULONG)lpInt[idx1])
					{
						// We have a selected file to not put in the new structure.
						//.........................................................
						idx1++;
					}
					else
					{
						// Not a selected file to delete. Copy it to the new structure.
						//.............................................................
						if (ulResult = CopyAttachment(lpAttach1,&lpAttach1[idx2],
													  &lpAttachT[idx]))
						{
							goto AttachEnd;
						}
						idx2++;
					}
				}
				ulResult = MAPI_USER_ABORT;

				// Free the memory of the old file list.
				//......................................
				bErr = PvFree((LPBYTE)lpAttachT);

				if (!bErr)
				{
					ulResult = SUCCESS_SUCCESS;

					// Return the new file list.
					//..........................
					lpAttach = lpAttach1;
					cAttach = dwNewTotal;

					// Reset the new list of files in the list box.
					//.............................................
					SendMessage(hControl,LB_RESETCONTENT,0,0);

					// Now put in the names of the files left.
					//........................................
					for (idx = 0; idx < cAttach; idx++)
					{
						if (lpAttach[idx].lpszFileName)
						{
							SendDlgItemMessage(hDlg,IDC_ATTACHMENT,LB_ADDSTRING,0,
											  (LPARAM)lpAttach[idx].lpszFileName);
						}
					}
				}

			}
		}
		else if (bResult == IDM_RTF_SELECTALL1)
		{
			SendMessage(hControl,LB_SETSEL,TRUE,-1);
		}
	}

	AttachEnd:

	if(ulResult)
	{
		if (lpAttach1)
		{
			PvFree((LPBYTE)lpAttach1);
		}
	}

	if (hMenu)
	{
		DestroyMenu(hMenu);
	}
	if (lpInt)
	{
		DeallocateMemory(lpInt);
	}
}

// Popup menu for the rtf control.
//................................
VOID RtfContextMenu(HWND hDlg, HWND hControl, LPARAM lParam, int iIDControl)
{
	HMENU			hMenu = 0;
	BOOL			bResult;
	int				x, y, i;
	RECT			rc;
	LONG			lResult;
	CHARRANGE		crange;
	BOOL			bTextFmt;
	BOOL			bRtfFmt;
	DWORD			dwTotalChar1;
	DWORD			dwTotalChar2;
	DWORD			dwParaHelp;
	LPTSTR			lpExt;
	BOOL			bErr;
	int				iResult;
	OPENFILENAME	ofn;
	TCHAR			szFileName[MAX_PATH];

	SetupRtfContextMenu();

	hMenu = CreatePopupMenu();
	if (!hMenu)
	{
		goto RtfEnd;
	}
	// Setup the findreplace structure.
	//.................................
	ZeroMemory(&FindReplace,sizeof(FINDREPLACE));
	FindReplace.lStructSize = sizeof(FINDREPLACE);
	FindReplace.hwndOwner = hDlg;
	FindReplace.Flags = FR_ENABLEHOOK | FR_SHOWHELP | FR_DOWN;

	hCurrentRtfWnd = hControl;

	// Determine the state of the various menu items.
	//...............................................
	lResult = SendMessage(hControl,EM_CANUNDO,0,0);
	if (lResult)
	{
		miiUndo.fState = MFS_ENABLED;
	}
	lResult = SendMessage(hControl,EM_CANREDO,0,0);
	if (lResult)
	{
		miiRedo.fState = MFS_ENABLED;
	}
	SendMessage(hControl,EM_EXGETSEL,0,(LPARAM)&crange);

	// See if we can turn highlight off on or not.
	//............................................
	cf.cbSize = sizeof(CHARFORMAT2);
	SendMessage(hControl,EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
	if (cf.dwEffects & CFE_AUTOBACKCOLOR)
	{
		miiHighLightOff.fState = MFS_GRAYED;
	}
	// Get the total number of characters in the rtf control.
	//.......................................................
	dwTotalChar1 = GetTheTotalCharacters(hControl);

	dwTotalChar2 = crange.cpMax - crange.cpMin;

	if (crange.cpMax != crange.cpMin)
	{
		miiCut.fState = MFS_ENABLED;
		miiCopy.fState = MFS_ENABLED;
		miiDelete.fState = MFS_ENABLED;
	}
	if (dwTotalChar2 >= dwTotalChar1)
	{
		miiSelectAll.fState = MFS_GRAYED;
	}
	else
	{
		miiSelectAll.fState = MFS_ENABLED;
	}
	// Set the save as if we have anything in the message.
	//....................................................
	if (dwTotalChar1 > 0)
	{
		miiSaveAs.fState = MFS_ENABLED;
		miiPrint.fState = MFS_ENABLED;
		miiFind.fState = MFS_ENABLED;
		miiReplace.fState = MFS_ENABLED;
	}
	// See if we have a clipboard format we can paste. Only accept
	// rtf or text.
	//............................................................
	bRtfFmt = IsClipboardFormatAvailable(RegisteredFormats[0]);
	bTextFmt = IsClipboardFormatAvailable(CF_TEXT);
	if (bRtfFmt || bTextFmt)
	{
		miiPaste.fState = MFS_ENABLED;
	}
	// Insert the menu items.
	//......................
	for (i = 0; i < (RTF_MENUITEMS - 2); i++)
	{
		bResult = InsertMenuItem(hMenu,i,TRUE,lpmii[i]);
		if (!bResult)
		{
			goto RtfEnd;
		}
	}
	x = LOWORD(lParam);
	y = HIWORD(lParam);

	if (x == 0xffff)
	{
		GetWindowRect(hControl,&rc);
		x = rc.left + ((rc.right - rc.left) / 2);
		y = rc.top + 25;
	}
	// Display the rtf context menu.
	//..............................
	bResult = TrackPopupMenuEx(hMenu,TPM_LEFTALIGN | TPM_TOPALIGN | 
							   TPM_NONOTIFY | TPM_RIGHTBUTTON |
							   TPM_RETURNCMD,x,y,hDlg,NULL);
	if (bResult)
	{
		// Process the returned commands.
		//...............................
		if (bResult == IDM_RTF_DELETE)
		{
			SendMessage(hControl,WM_CLEAR,0,0);
		}
		else if (bResult == IDM_RTF_UNDO)
		{
			SendMessage(hControl,EM_UNDO,0,0);
		}
		else if (bResult == IDM_RTF_REDO)
		{
			SendMessage(hControl,EM_REDO,0,0);
		}
		else if (bResult == IDM_RTF_CUT)
		{
			SendMessage(hControl,WM_CUT,0,0);
		}
		else if (bResult == IDM_RTF_COPY)
		{
			SendMessage(hControl,WM_COPY,0,0);
		}
		else if (bResult == IDM_RTF_PASTE)
		{
			SendMessage(hControl,WM_PASTE,0,0);
		}
		else if (bResult == IDM_RTF_SELECTALL)
		{
			crange.cpMin = 0;
			crange.cpMax = -1;
			SendMessage(hControl,EM_EXSETSEL,0,(LPARAM)&crange);
		}
		else if (bResult == IDM_RTF_HIGHON)
		{
			bChooseHighLightColor = TRUE;
			ZeroMemory(&crHL,sizeof(CHOOSECOLOR));
			lpIconPointer = lpszAppName;

			crHL.lStructSize = sizeof(CHOOSECOLOR);
			crHL.hwndOwner = hDlg;
			crHL.rgbResult = crHLCurrent;
			crHL.lpCustColors = (LPDWORD)crHLCustom;
			crHL.lpfnHook = MyCCHookProc;
			crHL.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

			// Go and get the color selection.
			//...............................
			if(!ChooseColor(&crHL))
			{
				CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
			}
			else
			{
				cf.cbSize = sizeof(CHARFORMAT2);
				SendMessage(hControl,EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);

				// If auto backcolor is on turn it off.
				//.....................................
				if (cf.dwEffects & CFE_AUTOBACKCOLOR)
				{
					cf.dwEffects ^= CFE_AUTOBACKCOLOR;
				}
				// We have a valid color selection.
				//.................................
				crHLCurrent = crHL.rgbResult;
				cf.dwMask |= CFM_BACKCOLOR;
				cf.crBackColor = crHLCurrent;
				SendMessage(hControl,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
			}
			bChooseHighLightColor = FALSE;
		}
		else if (bResult == IDM_RTF_HIGHOFF)
		{
			cf.cbSize = sizeof(CHARFORMAT2);
			SendMessage(hControl,EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
			cf.dwEffects |= CFE_AUTOBACKCOLOR;
			SendMessage(hControl,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
		}
		else if (bResult == IDM_RTF_FIND)
		{
			lpFind = AllocateMemory(FINDSTRINGLENGTH);
			ZeroMemory(&ft,sizeof(FINDTEXT));

			if (lpFind)
			{
				// See if we have highlighted a string.
				//.....................................
				if (crange.cpMax != crange.cpMin && dwTotalChar2 <= (FINDSTRINGLENGTH - 2))
				{
					SendMessage(hControl,EM_GETSELTEXT,0,(LPARAM)lpFind);
				}
				FindReplace.lpstrFindWhat = lpFind;
				FindReplace.wFindWhatLen = FINDSTRINGLENGTH;
				FindReplace.lpfnHook = MyFindHookProc;
				hFindReplace = FindText(&FindReplace);

				if (!hFindReplace)
				{
					CommDlgBoxErrorProc(IDS_FINDDLGBOX);
					DeallocateMemory(lpFind);
					lpFind = 0;
				}
			}
		}
		else if (bResult == IDM_RTF_REPLACE)
		{
			lpFind = AllocateMemory(FINDSTRINGLENGTH);
			lpReplaceWith = AllocateMemory(FINDSTRINGLENGTH);
			ZeroMemory(&ft,sizeof(FINDTEXT));

			if (lpFind && lpReplaceWith)
			{
				// See if we have highlighted a string.
				//.....................................
				if (crange.cpMax != crange.cpMin && dwTotalChar2 <= (FINDSTRINGLENGTH - 2))
				{
					SendMessage(hControl,EM_GETSELTEXT,0,(LPARAM)lpFind);
				}
				FindReplace.lpstrFindWhat = lpFind;
				FindReplace.lpstrReplaceWith = lpReplaceWith;
				FindReplace.wFindWhatLen = FINDSTRINGLENGTH;
				FindReplace.wReplaceWithLen = FINDSTRINGLENGTH;
				FindReplace.lpfnHook = MyFindHookProc;
				hFindReplace = ReplaceText(&FindReplace);

				if (!hFindReplace)
				{
					CommDlgBoxErrorProc(IDS_FIND_REPLACE);
					DeallocateMemory(lpFind);
					DeallocateMemory(lpReplaceWith);
					lpFind = 0;
					lpReplaceWith = 0;
				}
			}
			else
			{
				if (lpFind)
				{
					DeallocateMemory(lpFind);
					lpFind = 0;
				}
				if (lpReplaceWith)
				{
					DeallocateMemory(lpReplaceWith);
					lpReplaceWith = 0;
				}
			}
		}
		else if (bResult == IDM_RTF_IMPORT)
		{
			// Initialize the OPENFILENAME structure.
			//.......................................
			InitializeOFN(&ofn,SAVE_SOURCE);
			ZeroMemory(&szFileName,MAX_PATH);

			ofn.lpstrFile = szFileName;
			ofn.nMaxFile = sizeof(szFileName);
			ofn.hwndOwner = hDlg;
			ofn.lpstrFilter = TEXT("Text or Rich Text File [.txt;.rtf]\0*.txt;*.rtf\0");
			ofn.nFilterIndex = 1;
			ofn.lpstrTitle = TEXT("Open a Text or Rich Text File to Import");
			ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
						 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
						 OFN_HIDEREADONLY);
			ofn.lpstrDefExt = TEXT("rtf");
			ofn.lpfnHook = MyOFNHookProc;

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;

			if (!GetOpenFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_GET_FILES);
				goto RtfEnd;
			}
			// Determine the type of file and open it.
			//........................................
			lpExt = PathFindExtension((LPCTSTR)&szFileName);
			if (*lpExt == '.')
			{
				lpExt++;

				if (iResult = lstrcmpi((LPCTSTR)lpExt,(LPCTSTR)TEXT("txt")) == 0)
				{
					bErr = OpenFileStreamIn((LPTSTR)&szFileName,
											 hDlg,iIDControl,SF_TEXT | SFF_SELECTION);
				}
				else if (iResult = lstrcmpi((LPCTSTR)lpExt,(LPCTSTR)TEXT("rtf")) == 0)
				{
					bErr = OpenFileStreamIn((LPTSTR)&szFileName,
											 hDlg,iIDControl,SF_RTF | SFF_SELECTION);
				}
			}
		}
		else if (bResult == IDM_RTF_SAVEAS)
		{
			bSaveAsText = FALSE;
			SaveMsgAs(hDlg,iIDControl);
			if (iIDControl == IDC_DIARYNOTE)
			{
				SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETMODIFY,FALSE,0);
			}
		}
		else if (bResult == IDM_RTF_PRINT)
		{
			PrintRTF(hDlg,hControl,iIDControl,IDC_SUBJECT);
			if (iIDControl == IDC_DIARYNOTE)
			{
				SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETMODIFY,FALSE,0);
			}
		}
		else if (bResult == IDM_RTF_PARAFMT)
		{
			pf.cbSize = sizeof(PARAFORMAT2);
			SendMessage(hControl,EM_GETPARAFORMAT,0,(LPARAM)&pf);

			dwParaHelp = ChangeHelpTopic(IDH_FORMAT_PARAGRAPH);

			iResult = DialogBox(hInst,TEXT("FORMATPARAGRAPH"),hDlg,
							   (DLGPROC)FormatParagraphProc);
			if (iResult == IDOK)
			{
				pf.dwMask = PFM_LINESPACING | PFM_OFFSET | PFM_STARTINDENT | 
						    PFM_RIGHTINDENT | PFM_SPACEBEFORE | PFM_SPACEAFTER;
				pf.cbSize = sizeof(PARAFORMAT2);
				
				SendMessage(hControl,EM_SETPARAFORMAT,0,(LPARAM)&pf);
			}
			ChangeHelpTopic(dwParaHelp);
		}
		else if (bResult == IDM_RTF_DATETIME)
		{
			dwParaHelp = ChangeHelpTopic(IDH_INSERTDATETIME);

			iResult = DialogBox(hInst,TEXT("DATETIMEPICKER"),hDlg,
							   (DLGPROC)DateTimePickerProc);
			if (iResult == IDOK)
			{
				SendMessage(hControl,EM_REPLACESEL,TRUE,(LPARAM)&szInsertBuffer);
			}
			ChangeHelpTopic(dwParaHelp);
		}
		else if (bResult == IDM_RTF_SMILEYS)
		{
			bFromChat = FALSE;
			GetMySmileys();
		}
		else if (bResult == IDM_RTF_PICTURE)
		{
			InsertPicture();
		}
	}

	RtfEnd:

	// Close the menu.
	//................
	if (hMenu)
	{
		DestroyMenu(hMenu);
	}
}

// Setup the smileys in a property sheet.
//.......................................
VOID GetMySmileys()
{
	PROPSHEETPAGE		psp[3];
    PROPSHEETHEADER		psh;

	ZeroMemory(&psp,sizeof(PROPSHEETPAGE) * 3);
	ZeroMemory(&psh,sizeof(PROPSHEETHEADER));

	// Setup the first page.
	//......................
	psp[0].dwSize = sizeof(PROPSHEETPAGE);
	psp[0].dwFlags = PSP_HASHELP;
	psp[0].hInstance = hInst;
	psp[0].pszTemplate = lpSetOne;
	psp[0].pfnDlgProc = SmileyProc1;
	psp[0].lParam = 0;
	psp[0].pszIcon = NULL;

	// Setup the second page.
	//.......................
	psp[1].dwSize = sizeof(PROPSHEETPAGE);
	psp[1].dwFlags = PSP_HASHELP;
	psp[1].hInstance = hInst;
	psp[1].pszTemplate = lpSetTwo;
	psp[1].pfnDlgProc = SmileyProc2;
	psp[1].lParam = 0;
	psp[1].pszIcon = NULL;

	// Setup the second page.
	//.......................
	psp[2].dwSize = sizeof(PROPSHEETPAGE);
	psp[2].dwFlags = PSP_HASHELP;
	psp[2].hInstance = hInst;
	psp[2].pszTemplate = lpSetThree;
	psp[2].pfnDlgProc = SmileyProc3;
	psp[2].lParam = 0;
	psp[2].pszIcon = NULL;

	// Setup the property sheet.
	//..........................
	psh.dwSize = sizeof(PROPSHEETHEADER);
	psh.dwFlags = PSH_HASHELP | PSH_PROPSHEETPAGE | PSH_USEICONID | PSH_USECALLBACK | PSH_NOAPPLYNOW; 
	psh.pfnCallback = PropertySheetProc;
	psh.hwndParent = hMainWindow;
	psh.hInstance = hInst;
	psh.pszCaption = (LPSTR)"Smileys";
	psh.nPages = sizeof(psp) / sizeof(PROPSHEETPAGE);
	psh.nStartPage = 0;
	psh.ppsp = (LPCPROPSHEETPAGE)&psp;
	psh.pszIcon = (LPCTSTR)lpszAppName;

	// Let's do it.
	//.............
	PropertySheet(&psh);

	SetFocus(hCurrentRtfWnd);
}

// Insert a smiley into a rich text edit control propertysheet 1.
//...............................................................
LRESULT CALLBACK SmileyProc1(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	HDC					hdcMem;
	LPDRAWITEMSTRUCT	lpdis;
	int					iIndex;
	BITMAP				bm;
	int					x;
	int					y;
	HANDLE				hSmiley;
	BOOL				bResult;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			CenterWindow(hPropertySheet,GetWindow(hPropertySheet,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_SMILEY1));
			PropSheet_CancelToClose(hPropertySheet);
			return(FALSE);
		}

		case WM_DRAWITEM:
		{
			lpdis = (LPDRAWITEMSTRUCT)lParam;

			// Get the index to the bitmap.
			//.............................
			iIndex = lpdis->CtlID - IDC_SMILEY1;

			if (lpdis->itemAction & ODA_DRAWENTIRE)
			{
				// Load the image.
				//................
				hSmiley = LoadImage(hInst,MAKEINTRESOURCE(SMILEY_BASE + iIndex),IMAGE_BITMAP,
									0,0,LR_LOADMAP3DCOLORS | LR_LOADTRANSPARENT);
				if (hSmiley)
				{
					GetObject(hSmiley,sizeof(BITMAP),&bm);
					hdcMem = CreateCompatibleDC(lpdis->hDC);
					SelectObject(hdcMem,hSmiley);

					// Center the item.
					//.................
					x = (lpdis->rcItem.right - bm.bmWidth) / 2;
					y = (lpdis->rcItem.bottom - bm.bmHeight) / 2;

					BitBlt(lpdis->hDC,x,y,bm.bmWidth,bm.bmHeight,hdcMem,0,0,SRCCOPY);

					if(lpdis->itemState & ODS_FOCUS)
					{
						DrawFocusRect(lpdis->hDC,&lpdis->rcItem);
					}
					DeleteDC(hdcMem);
					DeleteObject(hSmiley);
				}
			}
			if (lpdis->itemAction & ODA_FOCUS)
			{
				DrawFocusRect(lpdis->hDC,&lpdis->rcItem);

				if(lpdis->itemState & ODS_FOCUS)
				{
					SetFocus(GetDlgItem(hDlg,lpdis->CtlID));
				}
			}
		}
		break;

		case WM_COMMAND:
		{
			if (LOWORD(wParam) >= IDC_SMILEY1 && LOWORD(wParam) <= IDC_SMILEY60)
			{
				// Get the index of the smiley we selected.
				//.........................................
				iIndex = LOWORD(wParam) - IDC_SMILEY1;

				if (bFromChat)
				{
					// Just insert text into the message.
					//...................................
					szInsertSmiley[3] = LOBYTE(iIndex + 0x41);

					SendMessage(hChat2,EM_REPLACESEL,TRUE,(LPARAM)&szInsertSmiley);
					bResult = TRUE;
				}
				else
				{
					// Display the smiley in the rtf window.
					//......................................
					bResult = DisplayMySmiley(iIndex);
				}
				if (bResult)
				{
					NotifyMe();
				}
				break;
			}
		}
		break;

		case WM_NOTIFY:
		{
			switch (((NMHDR FAR *)lParam)->code) 
    		{
				// Initialize the checkboxes.
				//...........................
				case PSN_SETACTIVE:
				{
					// Return 0 to accept activation.
					//...............................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}
				break;

				case PSN_KILLACTIVE:
				{
					// Return FALSE to loose active status.
					//.....................................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}
				break;

				case PSN_RESET:
				{
					// All changes since last apply are cancelled.
					// Means we cancelled the procedure.
					//............................................
				}
				break;

				case PSN_HELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;	

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Insert a smiley into a rich text edit control propertysheet 2.
//...............................................................
LRESULT CALLBACK SmileyProc2(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	HDC					hdcMem;
	LPDRAWITEMSTRUCT	lpdis;
	int					iIndex;
	BITMAP				bm;
	int					x;
	int					y;
	HANDLE				hSmiley;
	BOOL				bResult;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			return(FALSE);
		}

		case WM_DRAWITEM:
		{
			lpdis = (LPDRAWITEMSTRUCT)lParam;

			// Get the index to the bitmap.
			//.............................
			iIndex = lpdis->CtlID - IDC_SMILEY1;

			if (lpdis->itemAction & ODA_DRAWENTIRE)
			{
				// Load the image.
				//................
				hSmiley = LoadImage(hInst,MAKEINTRESOURCE(SMILEY_BASE + iIndex),IMAGE_BITMAP,
									0,0,LR_LOADMAP3DCOLORS | LR_LOADTRANSPARENT);
				if (hSmiley)
				{
					GetObject(hSmiley,sizeof(BITMAP),&bm);
					hdcMem = CreateCompatibleDC(lpdis->hDC);
					SelectObject(hdcMem,hSmiley);

					// Center the item.
					//.................
					x = (lpdis->rcItem.right - bm.bmWidth) / 2;
					y = (lpdis->rcItem.bottom - bm.bmHeight) / 2;

					BitBlt(lpdis->hDC,x,y,bm.bmWidth,bm.bmHeight,hdcMem,0,0,SRCCOPY);

					if(lpdis->itemState & ODS_FOCUS)
					{
						DrawFocusRect(lpdis->hDC,&lpdis->rcItem);
					}
					DeleteDC(hdcMem);
					DeleteObject(hSmiley);
				}
			}
			if (lpdis->itemAction & ODA_FOCUS)
			{
				DrawFocusRect(lpdis->hDC,&lpdis->rcItem);

				if(lpdis->itemState & ODS_FOCUS)
				{
					SetFocus(GetDlgItem(hDlg,lpdis->CtlID));
				}
			}
		}
		break;

		case WM_COMMAND:
		{
			if (LOWORD(wParam) >= IDC_SMILEY61 && LOWORD(wParam) <= IDC_SMILEY120)
			{
				// Get the index of the smiley we selected.
				//.........................................
				iIndex = LOWORD(wParam) - IDC_SMILEY1;

				if (bFromChat)
				{
					// Just insert text into the message.
					//...................................
					szInsertSmiley[3] = LOBYTE(iIndex + 132);

					SendMessage(hChat2,EM_REPLACESEL,TRUE,(LPARAM)&szInsertSmiley);
					bResult = TRUE;
				}
				else
				{
					// Display the smiley in the rtf window.
					//......................................
					bResult = DisplayMySmiley(iIndex);
				}
				if (bResult)
				{
					NotifyMe();
				}
				break;
			}
		}
		break;

		case WM_NOTIFY:
		{
			switch (((NMHDR FAR *)lParam)->code) 
    		{
				// Initialize the checkboxes.
				//...........................
				case PSN_SETACTIVE:
				{
					// Return 0 to accept activation.
					//...............................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}
				break;

				case PSN_KILLACTIVE:
				{
					// Return FALSE to loose active status.
					//.....................................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}
				break;

				case PSN_RESET:
				{
					// All changes since last apply are cancelled.
					// Means we cancelled the procedure.
					//............................................
				}
				break;

				case PSN_HELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;	

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Insert a smiley into a rich text edit control propertysheet 3.
//...............................................................
LRESULT CALLBACK SmileyProc3(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	HDC					hdcMem;
	LPDRAWITEMSTRUCT	lpdis;
	int					iIndex;
	BITMAP				bm;
	int					x;
	int					y;
	HANDLE				hSmiley;
	BOOL				bResult;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			return(FALSE);
		}

		case WM_DRAWITEM:
		{
			lpdis = (LPDRAWITEMSTRUCT)lParam;

			// Get the index to the bitmap.
			//.............................
			iIndex = lpdis->CtlID - IDC_SMILEY1;

			if (lpdis->itemAction & ODA_DRAWENTIRE)
			{
				// Load the image.
				//................
				hSmiley = LoadImage(hInst,MAKEINTRESOURCE(SMILEY_BASE + iIndex),IMAGE_BITMAP,
									0,0,LR_LOADMAP3DCOLORS | LR_LOADTRANSPARENT);
				if (hSmiley)
				{
					GetObject(hSmiley,sizeof(BITMAP),&bm);
					hdcMem = CreateCompatibleDC(lpdis->hDC);
					SelectObject(hdcMem,hSmiley);

					// Center the item.
					//.................
					x = (lpdis->rcItem.right - bm.bmWidth) / 2;
					y = (lpdis->rcItem.bottom - bm.bmHeight) / 2;

					BitBlt(lpdis->hDC,x,y,bm.bmWidth,bm.bmHeight,hdcMem,0,0,SRCCOPY);

					if(lpdis->itemState & ODS_FOCUS)
					{
						DrawFocusRect(lpdis->hDC,&lpdis->rcItem);
					}
					DeleteDC(hdcMem);
					DeleteObject(hSmiley);
				}
			}
			if (lpdis->itemAction & ODA_FOCUS)
			{
				DrawFocusRect(lpdis->hDC,&lpdis->rcItem);

				if(lpdis->itemState & ODS_FOCUS)
				{
					SetFocus(GetDlgItem(hDlg,lpdis->CtlID));
				}
			}
		}
		break;

		case WM_COMMAND:
		{
			if (LOWORD(wParam) >= IDC_SMILEY121 && LOWORD(wParam) <= IDC_SMILEY180)
			{
				// Get the index of the smiley we selected.
				//.........................................
				iIndex = LOWORD(wParam) - IDC_SMILEY1;

				if (bFromChat)
				{
					if (iIndex <= 150)
					{
						// Just insert text into the message.
						//...................................
						szInsertSmiley[3] = LOBYTE(iIndex - 87);
					}
					else
					{
						szInsertSmiley[3] = LOBYTE(iIndex + 10);
					}

					SendMessage(hChat2,EM_REPLACESEL,TRUE,(LPARAM)&szInsertSmiley);
					bResult = TRUE;
				}
				else
				{
					// Display the smiley in the rtf window.
					//......................................
					bResult = DisplayMySmiley(iIndex);
				}
				if (bResult)
				{
					NotifyMe();
				}
				break;
			}
		}
		break;

		case WM_NOTIFY:
		{
			switch (((NMHDR FAR *)lParam)->code) 
    		{
				// Initialize the checkboxes.
				//...........................
				case PSN_SETACTIVE:
				{
					// Return 0 to accept activation.
					//...............................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}
				break;

				case PSN_KILLACTIVE:
				{
					// Return FALSE to loose active status.
					//.....................................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}
				break;

				case PSN_RESET:
				{
					// All changes since last apply are cancelled.
					// Means we cancelled the procedure.
					//............................................
				}
				break;

				case PSN_HELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;	

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Display the smiley in the rtf window.
//......................................
BOOL DisplayMySmiley(int iSmiley)
{
	BOOL			bResult = FALSE;
	int				nLogPixelsX;
    int				nLogPixelsY;
	HDC				hRtfdc = 0;
	HDC				hDc1 = 0;
	HDC				hdcMetaFile = 0;
	COLORREF		crWhite = RGB(255,255,255);
	HANDLE			hSmiley = 0;
	HBITMAP			hTransSmiley = 0;
	BITMAP			bm;
	int				iResult;
	BOOL			bGood;
	CHARFORMAT2		cr2;
	int				picw, pich, picwgoal, pichgoal;
	LPBYTE			lpRtfString = 0;
	int				iFamilyIndex;
	HMETAFILE		hMetaFile;
	UINT			uBytes = 0;
	LPBYTE			lpMetaBuffer = 0;
	LPBYTE			lpHexBuffer = 0;
	
	hRtfdc = GetDC(hCurrentRtfWnd);
	if (!hRtfdc)
	{
		goto SmileyEnd;
	}
	// Get the font information from the rtf control.
	//...............................................
	cr2.cbSize = sizeof(CHARFORMAT2);
	SendMessage(hCurrentRtfWnd,EM_GETCHARFORMAT,1,(LPARAM)&cr2);

	nLogPixelsX = GetDeviceCaps(hRtfdc,LOGPIXELSX);
    nLogPixelsY = GetDeviceCaps(hRtfdc,LOGPIXELSY);
	
	// Create the second compatable DC.
	//.................................
	hDc1 = CreateCompatibleDC(hRtfdc);
	if (!hDc1)
	{
		goto SmileyEnd;
	}
	// Load the smiley bitmap.
	//........................
	hSmiley = LoadImage(hInst,MAKEINTRESOURCE(SMILEY_BASE + iSmiley),IMAGE_BITMAP,
					    0,0,LR_DEFAULTCOLOR);
	if (hSmiley)
	{
		iResult = GetObject(hSmiley,sizeof(BITMAP),&bm);
		if (!iResult)
		{
			goto SmileyEnd;
		}
		if (crOleBkg != crWhite)
		{
			// Replace the white in the bitmap with the current background color.
			//...................................................................
			hTransSmiley = ReplaceColor(hSmiley,crWhite,crOleBkg,hRtfdc);
			if (!hTransSmiley)
			{
				goto SmileyEnd;
			}
			SelectObject(hDc1,hTransSmiley);
		}
		else
		{
			SelectObject(hDc1,hSmiley);
		}
		// Calculate the required values for the \pic entry.
		//..................................................
		picw = MyCalcs(bm.bmWidth,HMM_PER_INCH,nLogPixelsX);
		pich = MyCalcs(bm.bmHeight,HMM_PER_INCH,nLogPixelsY);
		picwgoal = MyCalcs(bm.bmWidth,TWIPS_PER_INCH,nLogPixelsX);
		pichgoal = MyCalcs(bm.bmHeight,TWIPS_PER_INCH,nLogPixelsY);

		iFamilyIndex = (cr2.bPitchAndFamily & 0xf0) >> 4;
		if (iFamilyIndex > 7)
		{
			iFamilyIndex = 0;
		}
		// Lets create the metafile.
		//..........................
		hdcMetaFile = CreateMetaFile(NULL);
		if (!hdcMetaFile)
		{
			goto SmileyEnd;
		}
		SetMapMode(hdcMetaFile,MM_ANISOTROPIC);
		SetWindowExtEx(hdcMetaFile,0,0,NULL);
		SetViewportExtEx(hdcMetaFile,1,1,NULL);

		// Copy the bitmap into the metafile device context.
		//..................................................
		bGood = BitBlt(hdcMetaFile,0,0,bm.bmWidth,bm.bmHeight,hDc1,0,0,SRCCOPY);
		if (!bGood)
		{
			goto SmileyEnd;
		}
		hMetaFile = CloseMetaFile(hdcMetaFile);
		if (!hMetaFile)
		{
			goto SmileyEnd;
		}
		// First get the number of bytes required.
		//........................................
		uBytes = GetMetaFileBitsEx(hMetaFile,0,NULL);
		if (!uBytes)
		{
			goto SmileyEnd;
		}
		lpMetaBuffer = AllocateMemory(uBytes + 16);
		if (!lpMetaBuffer)
		{
			goto SmileyEnd;
		}
		uBytes = GetMetaFileBitsEx(hMetaFile,uBytes,lpMetaBuffer);
		if (!uBytes)
		{
			goto SmileyEnd;
		}
		lpHexBuffer = AllocateMemory((uBytes * 2) + 2);
		if (!lpHexBuffer)
		{
			goto SmileyEnd;
		}
		// Convert the buffer to hex.
		//...........................
		ChangeToHex(uBytes,lpMetaBuffer,lpHexBuffer,FORWARD);

		// Allocate memory for the final rtf string.
		//..........................................
		lpRtfString = AllocateMemory((uBytes * 2) + 2048);
		if (!lpRtfString)
		{
			goto SmileyEnd;
		}
		StringCbPrintf((LPTSTR)lpRtfString,((uBytes * 2) + 2048),(LPCTSTR)&szRTFHeader,
					   (LPCTSTR)lpFontFamily[iFamilyIndex],
					   (LPCTSTR)&cr2.szFaceName,picw,pich,picwgoal,pichgoal);

		StringCbCatEx((LPTSTR)lpRtfString,((uBytes * 2) + 2048),(LPCTSTR)lpHexBuffer,NULL,
					   NULL,dwStringSafeFlag);
		StringCbCatEx((LPTSTR)lpRtfString,((uBytes * 2) + 2048),(LPCTSTR)&szRTFImagePost,
					   NULL,NULL,dwStringSafeFlag);

		// Stream the rtf data into our rtf control.
		//..........................................
		dwPageCount = lstrlen(lpRtfString);
		lpOutBuffer = lpRtfString;
		eStreamRecv.dwCookie = (DWORD)lpOutBuffer;
		eStreamRecv.dwError = 0;
		eStreamRecv.pfnCallback = EditStreamPageInCallback;

		SendMessage(hCurrentRtfWnd,EM_STREAMIN,(WPARAM)SF_RTF | SFF_SELECTION,
					(LPARAM)&eStreamRecv);
		if (eStreamRecv.dwError)
		{
			goto SmileyEnd;
		}
		SendMessage(hCurrentRtfWnd,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cr2);
		bResult = TRUE;
	}

	SmileyEnd:

	if (hRtfdc)
	{
		ReleaseDC(hCurrentRtfWnd,hRtfdc);
	}
	if (hDc1)
	{
		DeleteDC(hDc1);
	}
	if (hSmiley)
	{
		DeleteObject(hSmiley);
	}
	if (hTransSmiley)
	{
		DeleteObject(hTransSmiley);
	}
	if (lpRtfString)
	{
		ZeroMemory(lpRtfString,((uBytes * 2) + 2048));
		DeallocateMemory(lpRtfString);
	}
	if (hMetaFile)
	{
		DeleteMetaFile(hMetaFile);
	}
	if (lpMetaBuffer)
	{
		ZeroMemory(lpMetaBuffer,(uBytes + 16));
		DeallocateMemory(lpMetaBuffer);
		lpMetaBuffer = 0;
	}
	if (lpHexBuffer)
	{
		ZeroMemory(lpHexBuffer,((uBytes * 2) + 2));
		DeallocateMemory(lpHexBuffer);
		lpHexBuffer = 0;
	}
	return(bResult);
}

// Select a date or time to insert into your message.
//...................................................
LRESULT CALLBACK DateTimePickerProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	SYSTEMTIME		st;
	TCHAR			szBuffer[256];
	int				i;
	UINT			uCheck;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Lets get the system date and time and populate the list box.
			//.............................................................
			if (bUseGmt)
			{
				GetSystemTime(&st);
				uCheck = BST_CHECKED;
			}
			else
			{
				GetLocalTime(&st);
				uCheck = BST_UNCHECKED;
			}
			CheckDlgButton(hDlg,IDC_USEGMT,uCheck);

			// Display the proper formated dates and times.
			//.............................................
			for (i= 0; i < DATE_ITEMS; i++)
			{
				if (i < (DATE_ITEMS - 4))
				{
					if (bUseGmt)
					{
						GetDateFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpGMTFormat[i],
									 (LPTSTR)&szBuffer,sizeof(szBuffer));
					}
					else
					{
						GetDateFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpFormat[i],
									 (LPTSTR)&szBuffer,sizeof(szBuffer));
					}
				}
				else
				{
					if (bUseGmt)
					{
						GetTimeFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpGMTFormat[i],
									 (LPTSTR)&szBuffer,sizeof(szBuffer));
					}
					else
					{
						GetTimeFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpFormat[i],
									 (LPTSTR)&szBuffer,sizeof(szBuffer));
					}
				}
				SendMessage(GetDlgItem(hDlg,IDC_DATETIMELIST),LB_ADDSTRING,0,
						   (LPARAM)&szBuffer);
			}
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_DATETIMELIST:
				{
					if (HIWORD(wParam) != LBN_DBLCLK)
					{
						break;
					}
				}
				
				case IDOK:
				{
					if (bUseGmt)
					{
						GetSystemTime(&st);
					}
					else
					{
						GetLocalTime(&st);
					}
					i = SendMessage(GetDlgItem(hDlg,IDC_DATETIMELIST),LB_GETCURSEL,0,0);
					if (i == LB_ERR)
					{
						break;
					}
					if (i < (DATE_ITEMS - 4))
					{
						if (bUseGmt)
						{
							GetDateFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpGMTFormat[i],
									     (LPTSTR)&szInsertBuffer,sizeof(szInsertBuffer));
						}
						else
						{
							GetDateFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpFormat[i],
									     (LPTSTR)&szInsertBuffer,sizeof(szInsertBuffer));
						}
					}
					else
					{
						if (bUseGmt)
						{
							GetTimeFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpGMTFormat[i],
										 (LPTSTR)&szInsertBuffer,sizeof(szInsertBuffer));
						}
						else
						{
							GetTimeFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpFormat[i],
										 (LPTSTR)&szInsertBuffer,sizeof(szInsertBuffer));
						}
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_USEGMT:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_USEGMT);

					if (uCheck == BST_CHECKED)
					{
						bUseGmt = FALSE;
						uCheck = BST_UNCHECKED;
					}
					else
					{
						bUseGmt = TRUE;
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_USEGMT,uCheck);

					// Clear the listbox.
					//...................
					SendMessage(GetDlgItem(hDlg,IDC_DATETIMELIST),LB_RESETCONTENT,0,0);

					if (bUseGmt)
					{
						GetSystemTime(&st);
					}
					else
					{
						GetLocalTime(&st);
					}
					// Display the proper formated dates and times.
					//.............................................
					for (i= 0; i < DATE_ITEMS; i++)
					{
						if (i < (DATE_ITEMS - 4))
						{
							if (bUseGmt)
							{
								GetDateFormat(LOCALE_USER_DEFAULT,0,&st,
											 (LPCTSTR)lpGMTFormat[i],
										     (LPTSTR)&szBuffer,sizeof(szBuffer));
							}
							else
							{
								GetDateFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpFormat[i],
										     (LPTSTR)&szBuffer,sizeof(szBuffer));
							}
						}
						else
						{
							if (bUseGmt)
							{
								GetTimeFormat(LOCALE_USER_DEFAULT,0,&st,
											 (LPCTSTR)lpGMTFormat[i],
											 (LPTSTR)&szBuffer,sizeof(szBuffer));
							}
							else
							{
								GetTimeFormat(LOCALE_USER_DEFAULT,0,&st,(LPCTSTR)lpFormat[i],
											 (LPTSTR)&szBuffer,sizeof(szBuffer));
							}
						}
						SendMessage(GetDlgItem(hDlg,IDC_DATETIMELIST),LB_ADDSTRING,0,
								   (LPARAM)&szBuffer);
					}
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Format a paragraph in a rich edit control.
//...........................................
LRESULT CALLBACK FormatParagraphProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	int		iMySpacing;
	BOOL	bReturn;
	LONG	lOffset;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Initialize the various fields.
			//...............................
			SetDlgItemInt(hDlg,IDC_START_INDENT,pf.dxStartIndent,FALSE);

			// We have to normalize the offset value.
			//.......................................
			lOffset = pf.dxOffset + pf.dxStartIndent;
			SetDlgItemInt(hDlg,IDC_SEQ_INDENT,lOffset,FALSE);

			SetDlgItemInt(hDlg,IDC_RIGHT_INDENT,pf.dxRightIndent,FALSE);
			SetDlgItemInt(hDlg,IDC_SPACEBEFORE,pf.dySpaceBefore,FALSE);
			SetDlgItemInt(hDlg,IDC_SPACEAFTER,pf.dySpaceAfter,FALSE);
			CheckRadioButton(hDlg,IDC_SPACE1,IDC_SPACE4,iSpacing);
			SetDlgItemInt(hDlg,IDC_SPECIFY,pf.dyLineSpacing,FALSE);

			// Set the limits on the text numbers to enter.
			//.............................................
			SendDlgItemMessage(hDlg,IDC_START_INDENT,EM_SETLIMITTEXT,(WPARAM)6,0);
			SendDlgItemMessage(hDlg,IDC_SEQ_INDENT,EM_SETLIMITTEXT,(WPARAM)7,0);
			SendDlgItemMessage(hDlg,IDC_RIGHT_INDENT,EM_SETLIMITTEXT,(WPARAM)7,0);
			SendDlgItemMessage(hDlg,IDC_SPACEBEFORE,EM_SETLIMITTEXT,(WPARAM)6,0);
			SendDlgItemMessage(hDlg,IDC_SPACEAFTER,EM_SETLIMITTEXT,(WPARAM)6,0);
			SendDlgItemMessage(hDlg,IDC_SPECIFY,EM_SETLIMITTEXT,(WPARAM)6,0);

			// Now disable the specify windows.
			//.................................
			if (iSpacing != IDC_SPACE4)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_SPECIFY_TEXT),FALSE);
				EnableWindow(GetDlgItem(hDlg,IDC_SPECIFY),FALSE);
			}
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_SPACE1:
				case IDC_SPACE2:
				case IDC_SPACE3:
				case IDC_SPACE4:
				{
					iMySpacing = LOWORD(wParam);

					if (iMySpacing == iSpacing)
					{
						break;
					}
					CheckRadioButton(hDlg,IDC_SPACE1,IDC_SPACE4,iMySpacing);

					// If we had specify turn it off.
					//...............................
					if (iSpacing == IDC_SPACE4)
					{
						EnableWindow(GetDlgItem(hDlg,IDC_SPECIFY_TEXT),FALSE);
						EnableWindow(GetDlgItem(hDlg,IDC_SPECIFY),FALSE);
					}
					// If We enabled spacing turn it on.
					//..................................
					if (iMySpacing == IDC_SPACE4)
					{
						EnableWindow(GetDlgItem(hDlg,IDC_SPECIFY_TEXT),TRUE);
						EnableWindow(GetDlgItem(hDlg,IDC_SPECIFY),TRUE);
					}
					iSpacing = iMySpacing;
				}
				break;

				case IDOK:
				{
					// Get the values from the edit controls.
					//.......................................
					pf.dxStartIndent = GetDlgItemInt(hDlg,IDC_START_INDENT,&bReturn,FALSE);
					pf.dxOffset = GetDlgItemInt(hDlg,IDC_SEQ_INDENT,&bReturn,FALSE);
					pf.dxRightIndent = GetDlgItemInt(hDlg,IDC_RIGHT_INDENT,&bReturn,FALSE);
					pf.dySpaceBefore = GetDlgItemInt(hDlg,IDC_SPACEBEFORE,&bReturn,FALSE);
					pf.dySpaceAfter = GetDlgItemInt(hDlg,IDC_SPACEAFTER,&bReturn,FALSE);

					// Special case for start indent equal to 0 with an offset value.
					//...............................................................
					if (pf.dxStartIndent == 0 && pf.dxOffset > 0)
					{
						pf.dxStartIndent = pf.dxOffset;
						pf.dxOffset = 0;
					}
					else
					{
						// Make the offset value relative to the start indent value.
						// It can be a negative value.
						//..........................................................
						pf.dxOffset -= pf.dxStartIndent;
					}
					// Setup the line spacing.
					//........................
					pf.dyLineSpacing = 0;

					if (iSpacing == IDC_SPACE1)
					{
						pf.bLineSpacingRule = 0;
					}
					else if (iSpacing == IDC_SPACE2)
					{
						pf.bLineSpacingRule = 1;
					}
					else if (iSpacing == IDC_SPACE3)
					{
						pf.bLineSpacingRule = 2;
					}
					else if (iSpacing == IDC_SPACE4)
					{
						pf.bLineSpacingRule = 3;
						pf.dyLineSpacing = GetDlgItemInt(hDlg,IDC_SPECIFY,&bReturn,FALSE);
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Get the total number of characters in the richedit control.
//............................................................
DWORD GetTheTotalCharacters(HWND hRtf)
{
	LONG		lResult;
	int			iIdx = 0;
	DWORD		dwCount = 0;

	while(TRUE)
	{
		lResult = SendMessage(hRtf,EM_LINEINDEX,(WPARAM)iIdx,0);
		if (lResult == -1)
		{
			break;
		}
		dwCount += SendMessage(hRtf,EM_LINELENGTH,(WPARAM)lResult,0);
		iIdx++;
	}
	return(dwCount);
}

// Save a message in a rtf box as a file.
//.......................................
VOID SaveMsgAs(HWND hDlg, int iIDRtf)
{
	OPENFILENAME		ofn;
	BOOL				bResult;
	UINT				uFormat;
	TCHAR				szBuffer[512];

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_DESTINATION);

	// Initialize with specific information for our packed file.
	//..........................................................
	ofn.lpstrFile = szFileToEncipher;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = hMainWindow;
	if (bSaveAsText)
	{
		ofn.lpstrFilter = TEXT("Text File [*.txt]\0*.txt\0All Files [*.*]\0*.*\0");
	}
	else
	{
		ofn.lpstrFilter = TEXT("Rich Text File [*.rtf]\0*.rtf\0All Files [*.*]\0*.*\0");
	}
	ofn.nFilterIndex = 1;
	ofn.Flags = (OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_NONETWORKBUTTON | 
				 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_OVERWRITEPROMPT |
				 OFN_HIDEREADONLY);
	if (bSaveAsText)
	{
		ofn.lpstrTitle = TEXT("Save Message As Plain Text File");
		ofn.lpstrDefExt = TEXT("txt");
		uFormat = SF_TEXT;
	}
	else
	{
		ofn.lpstrTitle = TEXT("Save Message As Rich Text File");
		ofn.lpstrDefExt = TEXT("rtf");
		uFormat = SF_RTF;
	}
	ofn.lpfnHook = MyOFNHookProc;

	// Get a destination and file name to save the rtf file to.
	//.........................................................
	ZeroMemory(&szFileToEncipher,MAX_PATH);

	// Get the name and path we want to use for our rtf file.
	//.......................................................
	if (!GetSaveFileName(&ofn))
	{
		CommDlgBoxErrorProc(IDS_SAVE_AS);
		return;
	}
	SaveDirName((LPBYTE)&szFileToEncipher,SAVE_DESTINATION,TRUE);

	EmptyTheMessageQue();

	// Create the file.
	//.................
	bResult = CreateFileStreamOut((LPTSTR)&szFileToEncipher,hDlg,iIDRtf,uFormat,FALSE);
	if (bResult)
	{
		StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szMsgSaveAs,
						&szFileToEncipher);
		MessageBoxProc(hDlg,IDS_ADVISORY,(UINT)&szBuffer,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}
	EmptyTheMessageQue();
}

// Save the directory name so the next time you open or save a file
// you can return to this directory.
//.................................................................
VOID SaveDirName(LPBYTE lpDirName, DWORD dwDestination, BOOL bRemoveFileName)
{
	TCHAR		szDirDup[MAX_PATH];

	CopyMemory(&szDirDup,lpDirName,MAX_PATH);
	if (bRemoveFileName)
	{
		PathRemoveFileSpec((LPTSTR)&szDirDup);
	}
	if (dwDestination & SAVE_SOURCE || dwDestination & SAVE_DESTINATION)
	{
		CopyMemory(&szPreviousSourceDir,&szDirDup,MAX_PATH);
		CopyMemory(&szPreviousDestinationDir,&szDirDup,MAX_PATH);
	}
	if (dwDestination & SAVE_ENCRYPT_DIR)
	{
		CopyMemory(&cfg.szPreviousEncFiles,&szDirDup,MAX_PATH);
	}
	if (dwDestination & SAVE_OTPKEYFILES)
	{
		CopyMemory(&cfg.szPreviousOTPKeyFiles,&szDirDup,MAX_PATH);
	}
	if (dwDestination & SAVE_TOTPFILES)
	{
		CopyMemory(&cfg.szPreviousTOTPFiles,&szDirDup,MAX_PATH);
	}
	if (dwDestination & SAVE_DIARYFILES)
	{
		CopyMemory(&cfg.szPreviousDiaryFiles,&szDirDup,MAX_PATH);
	}
}

// Print the contents of a rich text edit control.
//................................................
VOID PrintRTF(HWND hDlg, HWND hRTF, int iIDRTF, int iIDSubj)
{
	HDC				hDC = 0;
	DOCINFO			di;
	FORMATRANGE		fr;
	DWORD			dwCount;
	LONG			cb;
	LONG			cLines;
	int				nHorizRes;
	int				nVertRes;
    int				nLogPixelsX;
    int	            nLogPixelsY;
    LONG			lTextLength;   // Length of document.
    LONG			lTextPrinted;  // Amount of document printed.
	TCHAR			szPrtSubject[512];

	// Get a Device Context, DC, for the printer we are going to use.
	//...............................................................
	hDC = GetPrinterDC(hMainWindow,PD_HIDEPRINTTOFILE | PD_NOPAGENUMS | PD_NOSELECTION |
					   PD_RETURNDC | PD_SHOWHELP | PD_USEDEVMODECOPIESANDCOLLATE,1,1,1,1,1);

	EmptyTheMessageQue();
	
	// Return if no printer DC or we cancelled.
	//.........................................
	if (!hDC)
	{
		goto EndPrint;
	}

	nHorizRes = GetDeviceCaps(hDC,HORZRES);
	nVertRes = GetDeviceCaps(hDC,VERTRES);
	nLogPixelsX = GetDeviceCaps(hDC,LOGPIXELSX);
	nLogPixelsY = GetDeviceCaps(hDC,LOGPIXELSY);

	// Ensure the printer DC is in MM_TEXT mode.
	//..........................................
	SetMapMode(hDC,MM_TWIPS);

	// Rendering to the same DC we are measuring.
	//...........................................
	ZeroMemory(&fr,sizeof(fr));
	fr.hdc = fr.hdcTarget = hDC;

	// Set up the page.
	//.................
	fr.rcPage.left     = fr.rcPage.top = 0;
	fr.rcPage.right    = (nHorizRes/nLogPixelsX) * 1440;
	fr.rcPage.bottom   = (nVertRes/nLogPixelsY) * 1440;

	// Set up 1" margins all around.
	//..............................
	fr.rc.left   = fr.rcPage.left + 1440;  // 1440 TWIPS = 1 inch.
	fr.rc.top    = fr.rcPage.top + 1440;
	fr.rc.right  = fr.rcPage.right - 1440;
	fr.rc.bottom = fr.rcPage.bottom - 1440;

	// Default the range of text to print as the entire document.
	//...........................................................
	fr.chrg.cpMin = 0;
	fr.chrg.cpMax = -1;

	// Set up the print job (standard printing stuff here).
	//.....................................................
	ZeroMemory(&di,sizeof(di));
	di.cbSize = sizeof(DOCINFO);

	// Get the length of the subject line.
	//....................................
	dwCount = SendMessage(GetDlgItem(hDlg,iIDSubj),EM_LINELENGTH,0,0);

	if (dwCount)
	{
		GetDlgItemText(hDlg,iIDSubj,(LPTSTR)&szPrtSubject,sizeof(szPrtSubject));
		di.lpszDocName = (LPCTSTR)&szPrtSubject;
	}
	else
    {
		di.lpszDocName = "(Untitled)";

		// Do not print to file.
		//......................
		di.lpszOutput = NULL;
	}

	if (StartDoc(hDC,&di) <= 0)
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_STARTDOC,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto EndPrint;
	}

	// Find out real size of document in characters.
	//..............................................
	cb = 0;
	cLines = SendDlgItemMessage(hDlg,iIDRTF,EM_GETLINECOUNT,0,0L);

	if (cLines)
	{
		// Get the total number of bytes in the rich text edit control.
		//.............................................................
		cb = SendDlgItemMessage(hDlg,iIDRTF,EM_LINEINDEX,(UINT)cLines - 1,0L);
		cb += SendDlgItemMessage(hDlg,iIDRTF,EM_LINELENGTH,(UINT)cb,0L);
	}
	lTextLength = cb;

	do
    {
		// Start the page.
		//................
		if (StartPage(hDC) <= 0)
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_STARTPAGE,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto EndPrint;
		}

		// Print as much text as can fit on a page. The return value is the
		// index of the first character on the next page. Using TRUE for the
		// wParam parameter causes the text to be printed.
		//..................................................................
		lTextPrinted = SendMessage(hRTF,EM_FORMATRANGE,TRUE,(LPARAM)&fr);

		// End of the page.
		//.................
		if (EndPage(hDC) <= 0)
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_ENDPAGE,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto EndPrint;
		}

		// If there is more text to print, adjust the range of characters to
		// start printing at the first character of the next page.
		//...................................................................
		if (lTextPrinted < lTextLength)
        {
			fr.chrg.cpMin = lTextPrinted;
			fr.chrg.cpMax = -1;
        }
	}
	while(lTextPrinted < lTextLength);

	// Tell the control to release cached information.
	//................................................
	SendMessage(hRTF,EM_FORMATRANGE,0,(LPARAM)NULL);

	if (EndDoc(hDC) <= 0)
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_ENDDOC,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
	}

	EndPrint:

	if (pd.hDevMode)
	{
		GlobalFree(pd.hDevMode);
	}
	if (pd.hDevNames)
	{
		GlobalFree(pd.hDevNames);
	}
	if (hDC)
	{
		DeleteDC(hDC);
	}
}

// Setup a table of toolbar definitions.
//......................................
int SetupToolbarTable()
{
	int					iButtons;
	int					i;
	int					j;

	iButtons = lstrlen((LPCTSTR)&cfg.CurrentToolbar);

	lpTBButtons = AllocateMemory(iButtons * sizeof(TBBUTTON));

	for (i = 0; i < iButtons; i++)
	{
		for (j = 0; j < iTableDefs; j++)
		{
			if (cfg.CurrentToolbar[i] == ButtonDefs[j].ID)
			{
				CopyMemory(lpTBButtons + i,ButtonDefs[j].lpTBButton,sizeof(TBBUTTON));
				break;
			}
		}
	}
	return(iButtons);
}

// Get the current toolbar configuration.
//.......................................
VOID GetToolbarConfiguration()
{
	int			iButtons;
	int			i;
	TBBUTTON	tbButton;

	ZeroMemory(&cfg.CurrentToolbar,sizeof(cfg.CurrentToolbar));

	iButtons = SendMessage(hMyToolBar,TB_BUTTONCOUNT,0,0);

	for (i = 0; i < iButtons; i++)
	{
		SendMessage(hMyToolBar,TB_GETBUTTON,(WPARAM)i,(LPARAM)(LPTBBUTTON)&tbButton);

		if (tbButton.idCommand == 0)
		{
			cfg.CurrentToolbar[i] = 0xff;
		}
		else
		{
			cfg.CurrentToolbar[i] = (BYTE)LOWORD(LOBYTE(tbButton.idCommand));
		}
	}
}

// Set the contents of the clipboard to the passed text data.
//...........................................................
VOID SetMyClipboard(LPBYTE lpData)
{
	HGLOBAL			hClipboardMem;
	LPVOID			lpClipboardMem;
	DWORD			dwMemNeeded;
	BOOL			bMem;
	DWORD			dwErrCode;
	HANDLE			hClipboard;
	BOOL			bResult;

	dwMemNeeded = (lstrlen((LPCTSTR)lpData)) + 1;
	hClipboardMem = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT,dwMemNeeded);
	if (hClipboardMem == NULL)
	{
		ErrorProcedure((LPTSTR)lpszClipboard,IDS_ALLOCATEMEMORY,MB_OK);
		return;
	}
	lpClipboardMem = GlobalLock(hClipboardMem);
	if (lpClipboardMem == NULL)
	{
		ErrorProcedure((LPTSTR)lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		GlobalFree(hClipboardMem);
		return;
	}
	// Copy the data to the clipboard.
	//................................
	CopyMemory(lpClipboardMem,lpData,dwMemNeeded);

	// Unlock the memory for the clipboard.
	//.....................................
	bMem = GlobalUnlock(hClipboardMem);
	if (!bMem)
	{
		dwErrCode = GetLastError();
		if (dwErrCode != NO_ERROR)
		{
			SetLastError(dwErrCode);
			ErrorProcedure(lpszClipboard,IDS_UNLOCKMEMORY,MB_OK);
			return;
		}
	}
	// Open the Clipboard.
	//....................
	bResult = OpenClipboard(hMainWindow);
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
		return;
	}
	bResult = EmptyClipboard();
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_EMPTYCLIPBOARD,MB_OK);
		return;
	}
	hClipboard = SetClipboardData(CF_TEXT,hClipboardMem);
	if (!hClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_SETCLIPBOARD,MB_OK);
	}
	CloseClipboard();
}

// Find hook procedure.
//.....................
UINT CALLBACK MyFindHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			SetMyIcon(hDlg);
			CenterWindow(hDlg,hMainWindow);
			return(TRUE);
		}
		break;

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}
	}

	return(FALSE);
}

// Process the find dialog box.
//.............................
VOID MyFindDlgBox()
{
	LRESULT			lResult;
	DWORD			dwFlags = 0;
	LONG			lDiff;

	// See if we are closed.
	//......................
	if (lpFr->Flags & FR_DIALOGTERM)
	{
		if (lpFind)
		{
			ZeroMemory(lpFind,FINDSTRINGLENGTH);
			DeallocateMemory(lpFind);
		}
		if (lpReplaceWith)
		{
			ZeroMemory(lpReplaceWith,FINDSTRINGLENGTH);
			DeallocateMemory(lpReplaceWith);
		}
		lpFind = 0;
		lpReplaceWith = 0;
		hFindReplace = 0;
		hDlgCurrent = NULL;
	}
	else
	{
		if (lpFr->Flags & FR_DOWN)
		{
			dwFlags |= FR_DOWN;
		}
		if (lpFr->Flags & FR_MATCHCASE)
		{
			dwFlags |= FR_MATCHCASE;
		}
		if (lpFr->Flags & FR_WHOLEWORD)
		{
			dwFlags |= FR_WHOLEWORD;
		}
		// If we selected the find button.
		//................................
		if (lpFr->Flags & FR_FINDNEXT)
		{
			// Setup the find text structure.
			//...............................
			if (dwFlags & FR_DOWN)
			{
				ft.chrg.cpMin = 0;

				// If we have something highlighted we start from there.
				//......................................................
				SendMessage(hCurrentRtfWnd,EM_EXGETSEL,0,(LPARAM)&ft.chrgText);

				if (ft.chrgText.cpMin == ft.chrgText.cpMax)
				{
					ft.chrg.cpMin = 0;
				}
				else if (ft.chrgText.cpMax != -1)
				{
					ft.chrg.cpMin = ft.chrgText.cpMax;
				}
				ft.chrg.cpMax = -1;
			}
			else
			{
				// Going up.
				//..........
				ft.chrg.cpMin = 0;

				// If we have something highlighted we start from there.
				//......................................................
				SendMessage(hCurrentRtfWnd,EM_EXGETSEL,0,(LPARAM)&ft.chrgText);

				if (ft.chrgText.cpMin == ft.chrgText.cpMax)
				{
					ft.chrg.cpMin = 0;
				}
				else if (ft.chrgText.cpMin != -1)
				{
					ft.chrg.cpMin = ft.chrgText.cpMin;
				}
				ft.chrg.cpMax = 0;
			}
			ft.lpstrText = lpFind;
			lResult = SendMessage(hCurrentRtfWnd,EM_FINDTEXTEX,(WPARAM)dwFlags,(LPARAM)&ft);
			if (lResult != -1)
			{
				// Highlight the selected test.
				//.............................
				SendMessage(hCurrentRtfWnd,EM_EXSETSEL,0,(LPARAM)&ft.chrgText);

			}
		}
		else if (lpFr->Flags & FR_REPLACE)
		{
			// Find the difference of the two strings.
			//........................................
			lDiff = lstrlen((LPCTSTR)lpReplaceWith) - lstrlen((LPCTSTR)lpFind);

			// If we have something highlighted, replace it.
			//..............................................
			SendMessage(hCurrentRtfWnd,EM_EXGETSEL,0,(LPARAM)&ft.chrgText);

			if (ft.chrgText.cpMin != ft.chrgText.cpMax)
			{
				SendMessage(hCurrentRtfWnd,EM_REPLACESEL,(WPARAM)TRUE,(LPARAM)lpReplaceWith);
			}
			// Highlight the old selected text.
			//.................................
			SendMessage(hCurrentRtfWnd,EM_EXSETSEL,0,(LPARAM)&ft.chrgText);

			// Setup the find text structure.
			//...............................
			if (dwFlags & FR_DOWN)
			{
				ft.chrg.cpMin = 0;

				// If we have something highlighted we start from there.
				//......................................................
				SendMessage(hCurrentRtfWnd,EM_EXGETSEL,0,(LPARAM)&ft.chrgText);

				if (ft.chrgText.cpMin == ft.chrgText.cpMax)
				{
					ft.chrg.cpMin = 0;
				}
				else if (ft.chrgText.cpMax != -1)
				{
					ft.chrg.cpMin = ft.chrgText.cpMax + lDiff;
				}
				ft.chrg.cpMax = -1;
			}
			ft.lpstrText = lpFind;
			lResult = SendMessage(hCurrentRtfWnd,EM_FINDTEXTEX,(WPARAM)dwFlags,(LPARAM)&ft);
			
			// Highlight or unhighlight the selected test.
			//............................................
			SendMessage(hCurrentRtfWnd,EM_EXSETSEL,0,(LPARAM)&ft.chrgText);

			// Set if we are at the end and close the dialog box.
			//...................................................
			if (ft.chrgText.cpMin == -1)
			{
				PostMessage(hFindReplace,WM_COMMAND,IDABORT,0);
			}
		}
		else if (lpFr->Flags & FR_REPLACEALL)
		{
			// Find the difference of the two strings.
			//........................................
			lDiff = lstrlen((LPCTSTR)lpReplaceWith) - lstrlen((LPCTSTR)lpFind);

			while(TRUE)
			{
				// If we have something highlighted, replace it.
				//..............................................
				SendMessage(hCurrentRtfWnd,EM_EXGETSEL,0,(LPARAM)&ft.chrgText);

				if (ft.chrgText.cpMin != ft.chrgText.cpMax)
				{
					SendMessage(hCurrentRtfWnd,EM_REPLACESEL,(WPARAM)TRUE,(LPARAM)lpReplaceWith);
				}
				// Highlight the old selected text.
				//.................................
				SendMessage(hCurrentRtfWnd,EM_EXSETSEL,0,(LPARAM)&ft.chrgText);

				// Setup the find text structure.
				//...............................
				if (dwFlags & FR_DOWN)
				{
					ft.chrg.cpMin = 0;

					// If we have something highlighted we start from there.
					//......................................................
					SendMessage(hCurrentRtfWnd,EM_EXGETSEL,0,(LPARAM)&ft.chrgText);

					if (ft.chrgText.cpMin == ft.chrgText.cpMax)
					{
						ft.chrg.cpMin = 0;
					}
					else if (ft.chrgText.cpMax != -1)
					{
						ft.chrg.cpMin = ft.chrgText.cpMax + lDiff;
					}
					ft.chrg.cpMax = -1;
				}
				ft.lpstrText = lpFind;
				lResult = SendMessage(hCurrentRtfWnd,EM_FINDTEXTEX,(WPARAM)dwFlags,(LPARAM)&ft);
			
				// Highlight or unhighlight the selected test.
				//............................................
				SendMessage(hCurrentRtfWnd,EM_EXSETSEL,0,(LPARAM)&ft.chrgText);

				// Set if we are at the end and close the dialog box.
				//...................................................
				if (ft.chrgText.cpMin == -1)
				{
					PostMessage(hFindReplace,WM_COMMAND,IDABORT,0);
					break;
				}
			}
		}
	}
}

// ReplaceColor
//
// Author    : Dimitri Rochette drochette@ltezone.net
// Specials Thanks to Joe Woodbury for his comments and code corrections
//
// Includes  : Only <windows.h>
//
// hBmp	     : Source Bitmap
// cOldColor : Color to replace in hBmp
// cNewColor : Color used for replacement
// hBmpDC    : DC of hBmp
//
// Retcode   : HBITMAP of the modified bitmap or NULL for errors
//
//..............................................................................
HBITMAP ReplaceColor(HBITMAP hBmp, COLORREF cOldColor, COLORREF cNewColor, HDC hBmpDC)
{
    HBITMAP			RetBmp = NULL;
	HDC				BufferDC = NULL;
	HDC				DirectDC = NULL;
	BITMAP			bm;
	BITMAPINFO		RGB32BitsBITMAPINFO;
	UINT *			ptPixels;
	HBITMAP			DirectBitmap;
	HGDIOBJ			PreviousObject;
	HGDIOBJ			PreviousBufferObject;
	int				i;

    if (hBmp)
    {	
        BufferDC = CreateCompatibleDC(hBmpDC);	// DC for Source Bitmap

		if (BufferDC)
		{
            PreviousBufferObject = SelectObject(BufferDC,hBmp);

			// Here BufferDC contains the bitmap. DC for working.
			//...................................................
			DirectDC = CreateCompatibleDC(hBmpDC);

			if (DirectDC)
			{
				// Get bitmap size.
				//.................
				GetObject(hBmp,sizeof(bm),&bm);
				
				// Create a BITMAPINFO with minimal initilisation 
                // for the CreateDIBSection.
				//...............................................
				ZeroMemory(&RGB32BitsBITMAPINFO,sizeof(BITMAPINFO));
				RGB32BitsBITMAPINFO.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
				RGB32BitsBITMAPINFO.bmiHeader.biWidth=bm.bmWidth;
				RGB32BitsBITMAPINFO.bmiHeader.biHeight=bm.bmHeight;
				RGB32BitsBITMAPINFO.bmiHeader.biPlanes=1;
				RGB32BitsBITMAPINFO.bmiHeader.biBitCount=32;

				DirectBitmap = CreateDIBSection(DirectDC,(BITMAPINFO *)&RGB32BitsBITMAPINFO, 
												DIB_RGB_COLORS,(void **)&ptPixels,NULL,0);
				if (DirectBitmap)
				{
					GdiFlush();

					// Here DirectBitmap!=NULL so ptPixels!=NULL no need to test.
					//...........................................................
					PreviousObject = SelectObject(DirectDC,DirectBitmap);
					BitBlt(DirectDC,0,0,bm.bmWidth,bm.bmHeight,BufferDC,0,0,SRCCOPY);

					GdiFlush();
	
					// Here the DirectDC contains the bitmap.
					// Convert COLORREF to RGB (Invert RED and BLUE).
					//...............................................
					cOldColor = COLORREF2RGB(cOldColor);
					cNewColor = COLORREF2RGB(cNewColor);

					// After all the inits we can do the job : Replace Color.
					//.......................................................
					for (i = ((bm.bmWidth * bm.bmHeight)-1); i >= 0; i--)
					{
						if (ptPixels[i] == cOldColor)
						{
							ptPixels[i] = cNewColor;
						}
					}		
					// Little clean up.
					// Don't delete the result of SelectObject because it's 
                    // our modified bitmap (DirectBitmap).
					//.....................................................
					SelectObject(DirectDC,PreviousObject);
					
					// Finish.
					//........
					RetBmp = DirectBitmap;
				}
				// Clean up.
				//..........
				DeleteDC(DirectDC);
			}		
			SelectObject(BufferDC,PreviousBufferObject);

			// BufferDC is now useless.
			//.........................
			DeleteDC(BufferDC);
		}
    }
    return RetBmp;
}

// My calculations for a bitmap.
//..............................
int MyCalcs(LONG lbm, int iConst, int iLogPixels)
{
	int		iResult;

	__asm
	{
		xor		edx,edx
		mov		eax,lbm
		mov		ecx,iConst
		mul		ecx
		mov		ecx,iLogPixels
		div		ecx
		cmp		edx,0
		je		L1
		inc		eax
	L1:	mov		iResult,eax
	}
	return(iResult);
}
